<?php
class ProfileController extends SiteController{

	private $dao;

	public function __construct(){
		parent::__construct();
		$this->dao = new Order_Dao();
	}
	
	public function index(){
		$user = Auth_Auth::getUser();
		if($user == null){
		    if ($this->mobile) {
		         header('Location: /mlogin');
		         return;
            }
			throw new PageNotFoundException();
        }
		$this->layout = 'profile';
		$this->noCache();
		$result = array(Order_Status::NEW_ORDER => array(), Order_Status::READY => array(), Order_Status::TAKEN => array());
		$orders = $this->dao->all(Db_Criteria::create(array('user_id' => $user->id))->order('id desc'));
		$bids = array();
		foreach($orders as $order){
			$status = $order->status;
			if($order->status == Order_Status::TAKEN || $order->status == Order_Status::REFUSED || $order->status == Order_Status::EXPIRED || $order->status == Order_Status::ABSENT){
				$status = Order_Status::TAKEN;
			}
			$result[$status][] = $order;
		}
		$this->orders = $orders;
		$this->groupped = $result;
		
		$reviewDao = new Review_Dao();
		$this->reviews = $reviewDao->getPending($user);
	}
	
	public function password(){
		$user = Auth_Auth::getUser();
		if($user == null){
			throw new PageNotFoundException();
		}
		$this->layout = 'password';
		$this->noCache();
	}
	
	public function change($data){
		$user = Auth_Auth::getUser();
		if($user == null){
			throw new PageNotFoundException();
		}
		if($user->password != md5($data['old_password'])){
			$this->addFormError('old_password', 'not.correct');
			return;
		}
		$password = $data['new_password'];
		$p = md5($password);
		$this->userDao->update($user->id, array('password' => $p));
		$user->password = $p;
		Auth_Auth::storeUser($user, true);
//		Util::mail($user->email, 'reset', "Изменения пароля на портале Списанные Книги", array('login' => $user->email, 'password' => $password));
		Util::mail($user->email, 'change', "Изменения пароля на портале “Списанные книги”", array('login' => $user->email));
	}

    public function changeTel() {
	    $this->layout = 'tel';
    }

	public function doChangeTel($data){
        $user = Auth_Auth::getUser();
        if($user == null){
            throw new PageNotFoundException();
        }

	    $phone = '7'.preg_replace('/\D/', '', $data['phone']);
        $smsCode = rand(1000,9999);

        $this->userDao->update($user->id, array('new_phone' => $phone, 'phone_code' => $smsCode));

        try {
            $this->sendSmsCode($phone, $smsCode);
        } catch (Exception $e) {
            $this->addFormError('phone', 'no.sms');
        }

        $this->addFormData('phone', $phone);
    }

    public function sendSmsCode($phone, $smsCode){
        $smsCode = 'Код подтверждения: ' . $smsCode;
	    Util::sms($phone, $smsCode);
    }

    public function telConfirm(){
        $this->layout = 'tel-confirm';
    }

    public function doTelConfirm($data) {
        $user = Auth_Auth::getUser();
        if ($user == null) {
            throw new PageNotFoundException();
        }
        $smsCode = $data['confirm'];

        $currentUser = $this->userDao->one(Db_Criteria::create(['id' => $user->id]));
        if ($currentUser->phone_code == $smsCode) {
            $this->userDao->update($currentUser->id, [
                'phone' => $currentUser->new_phone,
                'new_phone' => null,
                'phone_code' => null
            ]);
        } else {
            $this->addFormError('confirm', 'not.correct');
        }
    }

    public function telConfirmSuccess() {}
}
?>