<?php
class SiteController extends AppController
{
	protected $userDao;
	
	protected $bookDao;
	
	protected $authorDao;
	
	protected $libraryDao;
	
	protected $categoryDao;
	
	protected $ageDao;

	protected $typeDao;

	protected $orderLogDao;
	
	protected $cart;
	
	public function __construct(){
		parent::__construct();
		$this->layout = "site";
		$this->userDao = new User_Dao();
		$this->bookDao = new Book_Dao();
		$this->authorDao = new Author_Dao();
		$this->libraryDao = new Library_Dao();
		$this->categoryDao = new Book_Category_Dao();
		$this->ageDao = new Book_Age_Dao();
		$this->typeDao = new Book_Type_Dao();
		$this->orderLogDao = new Order_Log_Dao();
		$this->cart = new Cart();
        /**
         * Setting memcached server
         */
        $this->cache = new Memcached();
        $this->cache->addServer("127.0.0.1", 11211);
	}
	
	public function before(){
		parent::before();
//		if(isset($_GET['token'])){
//			$user = $this->userDao->checkToken($_GET['token']);
//			if($user != null){
//				Auth_Auth::storeUser($user, true);
//			}
//		}
		$this->view->currentUser = Auth_Auth::getUser();
//		if(Route_Router::$route['controller'] != 'service' && !file_exists('.activated')){
//			Route_Router::$route['stop'] = true;
//			View_View::getInstance()->layout = 'welcome';
//			echo View_View::getInstance()->render();
//			return;
//		}
	}
	
	public function after()
	{
		if(!$this->output)
			return;			
		$this->view->route = $this->route;
		$this->view->presets = Presets_Dao::getPresets();
        $this->view->cartItems = [];
        $this->view->fundType = null;
		if ($this->view->currentUser) {
            $this->view->cartItems = $this->cart->get();
            $this->view->fundType = $this->cart->getFundType();
        }
//		$this->view->headMenuItems = $this->getMenuFromApi()['response'];
		$user = Auth_Auth::getUser();
		if($user != null && $user->isInRole(Roles::LIBRARY)){
			$orderItemDao = new Order_Item_Dao();
			$this->pendingBooksCount = $orderItemDao->count(Db_Criteria::create(array('library_id' => $user->library_id, 'status' => Order_Status::NEW_ORDER)));
		}
	}

	protected function getLibraries(&$ids){
        $libraries = $this->cache->get(md5(serialize($ids)));

	    if($libraries){
            $this->libraries = $libraries;
		}else{
            $ls = $this->libraryDao->get($ids);
            $libraries = array();
            if($ls != null) {
                foreach($ls as $l){
                    $libraries[$l->id] = $l;
                }
            }
            $this->libraries = $libraries;

            $key = md5(serialize($ids));
            $this->cache->set($key, $libraries, 3600);
		}
	}
	
//	protected function getAuthors(&$bookIds){
//		return $this->authors = Util::getAuthors($bookIds, $this->authorDao);
//	}

    protected function getAuthors(&$bookIds){
	    $cacheKey = md5(json_encode($bookIds));

	    $authors = $this->cache->get($cacheKey);

	    if ($authors != null) {
	        $this->authors = $authors;
        } else {
            $this->authors = Util::getAuthors($bookIds, $this->authorDao);
            $this->cache->set($cacheKey, $this->authors, 3600);
        }

        return $this->authors;
    }
	
	protected function getCategories(){
        if ($this->currentUser === null || $this->currentUser->isInRole(Roles::USER)) {
            $_fullCache = false;
        } else {
            $_fullCache = true;
        }

        $categories = $this->cache->get("categories");
        $plainCategories = $_fullCache ? $this->cache->get("plainCategories") : $this->cache->get("plainCategoriesMain");

        if ($categories && $plainCategories) {
            $this->plainCategories = $plainCategories;
            $this->categories = $categories;
        } else {
            $all = $this->categoryDao->all();
            $notEmpty = $this->categoryDao->all(Db_Criteria::create()->add(Db_Exp::gt('books_count', 0))->order('name asc'));
            $notEmptyMain = $this->categoryDao->all(Db_Criteria::create()->add(Db_Exp::gt('books_count_main', 0))->order('name asc'));

            $cats = [];
            foreach($all as $c){
                $cats[$c->id] = $c;
            }

            $this->plainCategories = $_fullCache ? $notEmpty : $notEmptyMain;

            $this->categories = $cats;
            /**
             * Setting memcached vars
             */
            $this->cache->set("plainCategories", $notEmpty, 3600);
            $this->cache->set("plainCategoriesMain", $notEmptyMain, 3600);
            $this->cache->set("categories", $cats, 3600);
        }
	}

    protected function getAges(){
        if ($this->currentUser === null || $this->currentUser->isInRole(Roles::USER)) {
            $_fullCache = false;
        } else {
            $_fullCache = true;
        }

        $bookAges = $this->cache->get("bookAges");
        $plainAges = $_fullCache ? $this->cache->get("plainAges") : $this->cache->get("plainAgesMain");

        if ($bookAges && $plainAges) {
            $this->plainAges = $plainAges;
            $this->ages = $bookAges;
        } else {
            $all = $this->ageDao->all();
            $notEmpty = $this->ageDao->all(Db_Criteria::create()->add(Db_Exp::gt('books_count', 0))->order('name asc'));
            $notEmptyMain = $this->ageDao->all(Db_Criteria::create()->add(Db_Exp::gt('books_count_main', 0))->order('name asc'));

            $ages = [];
            foreach($all as $a){
                $ages[$a->id] = $a;
            }

            $this->plainAges = $_fullCache ? $notEmpty : $notEmptyMain;

            $this->ages = $ages;
            /**
             * Setting memcached vars
             */
            $this->cache->set("plainAges", $notEmpty, 3600);
            $this->cache->set("plainAgesMain", $notEmpty, 3600);
            $this->cache->set("bookAges", $ages, 3600);
        }
    }

    protected function getTypes(){
        if ($this->currentUser === null || $this->currentUser->isInRole(Roles::USER)) {
            $_fullCache = false;
        } else {
            $_fullCache = true;
        }

        $bookTypes = $this->cache->get("bookTypes");
        $plainTypes = $_fullCache ? $this->cache->get("plainTypes") : $this->cache->get("plainTypesMain");

        if ($bookTypes && $plainTypes) {
            $this->plainTypes = $plainTypes;
            $this->types = $bookTypes;
        } else {
            $all = $this->typeDao->all();
            $notEmpty = $this->typeDao->all(Db_Criteria::create()->add(Db_Exp::gt('books_count', 0))->order('name asc'));
            $notEmptyMain = $this->typeDao->all(Db_Criteria::create()->add(Db_Exp::gt('books_count_main', 0))->order('name asc'));

            $types = [];
            foreach($all as $t){
                $types[$t->id] = $t;
            }

            $this->plainTypes = $_fullCache ? $notEmpty : $notEmptyMain;

            $this->types = $types;
            /**
             * Setting memcached vars
             */
            $this->cache->set("plainTypes", $notEmpty, 3600);
            $this->cache->set("plainTypesMain", $notEmpty, 3600);
            $this->cache->set("bookTypes", $types, 3600);
        }
    }

    protected function getRegions(){
        $regions = array();

        $searchRegions = $this->cache->get("regions");
        $plainRegions = $this->cache->get("plainRegions");

        if ($searchRegions && $plainRegions) {
            $this->plainRegions = $plainRegions;
            $this->regions = $searchRegions;
        } else {
            $all = $this->libraryDao->all(Db_Criteria::create()->sql("select distinct region from libraries where region is not null order by region asc"));
            foreach($all as $r){
                $regions[] = $r;
            }
            $this->plainRegions = $all;
            $this->regions = $regions;
            /**
             * Setting memcached vars
             */
            $this->cache->set("plainRegions", $all, 3600);
            $this->cache->set("regions", $regions, 3600);
        }
    }

    protected function getDistricts(){
        $districts = array();

        $searchDistricts = $this->cache->get("districts");
        $plainDistricts = $this->cache->get("plainDistricts");

        if ($searchDistricts && $plainDistricts) {
            $this->plainDistricts = $plainDistricts;
            $this->districts = $searchDistricts;
        } else {
            $all = $this->libraryDao->all(Db_Criteria::create()->sql("select distinct district from libraries where district is not null order by district asc"));
            foreach($all as $d){
                $districts[] = $d;
            }
            $this->plainDistricts = $all;
            $this->districts = $districts;
            /**
             * Setting memcached vars
             */
            $this->cache->set("plainDistricts", $all, 3600);
            $this->cache->set("districts", $districts, 3600);
        }
    }

    protected function getMetros(){
        $metros = array();

        $searchMetros = $this->cache->get("metros");
        $plainMetros = $this->cache->get("plainMetros");

        if ($searchMetros && $plainMetros) {
            $this->plainMetros = $plainMetros;
            $this->metros = $searchMetros;
        } else {
            $all = $this->libraryDao->all(Db_Criteria::create()->sql("select distinct metro from libraries where metro is not null order by metro asc"));
            foreach($all as $m){
                $metros[] = $m;
            }
            $this->plainMetros = $all;
            $this->metros = $metros;
            /**
             * Setting memcached vars
             */
            $this->cache->set("plainMetros", $all, 3600);
            $this->cache->set("metros", $metros, 3600);
        }
    }

    protected function getLangs(){
        $langs = array('ru' => 'Русский', 'en' => 'Иностранный язык');
        $this->langs = $langs;
    }

    protected function getBooks($baseUrl, $page, $library, $categories, $title, $age, $type, $bytitle, $byauthor, $region, $district, $metro, $lang, $fund, $ignoreLibraryFilter = false){
	    $perPage = 20;
        $sql = null;
        $filters = array();

        if ($this->currentUser && $this->currentUser->isInRole(Roles::LRENTITY)) {
            $fundType = null;
//            $fundType = Book_Fund::EXCHANGE;
        } else {
            $fundType = Book_Fund::ALLOTHER;
        }

        if($byauthor != null){
           $sql = "select books.*, (select min(authors.name) from books_authors join authors on authors.id = books_authors.author_id where books_authors.book_id = books.id) as author from books";

            $criteria = Db_Criteria::create()->before($sql);

            if ($fundType == null) {
                $criteria->add(array('status' => Book_Status::ACTIVE, 'published' => 1))->order(Db_Exp::orderBy('author', $byauthor));
            } else
                $criteria->add(array('status' => Book_Status::ACTIVE, 'published' => 1, 'fund_type' => $fundType))->order(Db_Exp::orderBy('author', $byauthor));

            $filters['byauthor'] = $byauthor;
        } else {
            if ($fundType == null) {
                $criteria = Db_Criteria::create(array('status' => Book_Status::ACTIVE, 'published' => 1));
            } else
                $criteria = Db_Criteria::create(array('status' => Book_Status::ACTIVE, 'published' => 1, 'fund_type' => $fundType));
        }
        if($library != null){
            $criteria->add(Db_Exp::eq('library_id', $library->id));
            if(!$ignoreLibraryFilter){
                $filters['library'] = $library->id;
            }
        }else{
            //$criteria->add(Db_Exp::sql("library_id in (select id from libraries where service = 1 and published = 1)"));
        }
//        if($category != null){
//            $criteria->add(Db_Exp::eq('category_id', $category->id));
//            $filters['category'] = $category->id;
//        }
        if(!empty($categories)){
            $categoriesIds = [];
            foreach ($categories as $category) {
                $categoriesIds[] = (int)$category->id;
            }
            $criteria->add(Db_Exp::in('category_id', $categoriesIds));
            $filters['category'] = implode(',', $categoriesIds);
        }
        if($age != null){
            $criteria->add(Db_Exp::eq('age_category_id', $age->id));
            $filters['age'] = $age->id;
        }
        if($type != null){
            $criteria->add(Db_Exp::eq('type_id', $type->id));
            $filters['type'] = $type->id;
        }
        if($region != null){
            $criteria->add(Db_Exp::sql("library_id in (select id from libraries where region = '" . $region . "')"));
            $filters['region'] = $region;
        }
        if($district != null){
            $criteria->add(Db_Exp::sql("library_id in (select id from libraries where district = '" . $district . "')"));
            $filters['district'] = $district;
        }
        if($metro != null){
            $criteria->add(Db_Exp::sql("library_id in (select id from libraries where metro = '" . $metro . "')"));
            $filters['metro'] = $metro;
        }
//        if($lang != null){
//            $criteria->add(Db_Exp::eq('lang', $lang));
//            $filters['lang'] = $lang;
//        }
        if($lang != null){
            if($lang == 'ru') {
                $criteria->add(Db_Exp::eq('lang', 'ru'));
            } else {
                $criteria->add(Db_Exp::ne('lang', 'ru'));
            }
            $filters['lang'] = $lang;
        }
        if($fund != null){
            switch ($fund) {
                case '1':
                    $fund = Book_Fund::ALLOTHER;
                    break;
                case '2':
                    $fund = Book_Fund::EXCHANGE;
                    break;
                default:
                    throw new PageNotFoundException();
            }
            $criteria->add(Db_Exp::eq('fund_type', $fund));
            $filters['fund'] = $fund;
        }
        if($bytitle != null){
            $criteria->order(Db_Exp::orderBy('title', $bytitle));
            $filters['bytitle'] = $bytitle;
        }

        $author = isset($_GET['author']) ? $_GET['author'] : null;
        if($author){
            $filters['author'] = htmlentities($author);
            $authors = $this->getRequestAuthors($author);
            if($authors){
                $aids = join(',', $authors);
                $criteria->add(Db_Exp::sql("id in (select book_id from books_authors where author_id in ($aids))"));
            }else{
                $criteria->add(Db_Exp::sql("id = 0"));
            }
        }

        if($title){
            $criteria->add(Db_Exp::like('title', mysqli_real_escape_string($GLOBALS["___mysqli_ston"], $title)));
            $filters['title'] = htmlentities($title, null, 'UTF-8');
        }

        $bookKey = array($page, $library, $categories, $title, $age, $type, $bytitle, $byauthor, $region, $district, $metro, $lang, $fund, $fundType, $author);
        $finalKey = md5(serialize($bookKey));

        if ($this->currentUser && $this->currentUser->isInRole(Roles::LRENTITY)) {
            $booksNoCbs = "library_id in (select id from libraries where cbs_sb_id not in (select cbs_sb_id from libraries where id in (select library_id from users where id = " . $this->currentUser . ")))";

            if ($byauthor != null) {
                $books = $this->bookDao->all($criteria->add(Db_Exp::sql($booksNoCbs))->page($page)->perPage($perPage));
            } else
                $books = $this->bookDao->all($criteria->add(Db_Exp::sql($booksNoCbs))->page($page)->perPage($perPage)->order('title asc'));
        } else {

            if ($byauthor != null) {
                $books = $this->bookDao->all($criteria->page($page)->perPage($perPage));
            } else {

                $books = $this->cache->get($finalKey);
                if ($books) {

                } else {
                    $books = $this->bookDao->all($criteria->page($page)->perPage($perPage)->order('title asc'));
                    $this->cache->set($finalKey, $books, 10);
                }
            }
        }

        $count = $this->bookDao->count($criteria);

        $this->page = $page + 1;
        $this->pages = ceil($count / $perPage);
        $this->count = $count;
        $this->books = $books;
        $this->baseUrl = $baseUrl;
        $this->filters = $filters;

        $ids = array();
        $libraryIds = array();
        foreach($books as $b){
            $ids[] = $b->id;
            $libraryIds[] = $b->library_id;
        }
        $libraryIds = array_unique($libraryIds);
        $this->getAuthors($ids);
        $this->getCategories();
        $this->getAges();
        $this->getTypes();
        $this->getRegions();
        $this->getDistricts();
        $this->getMetros();
        $this->getLangs();
        $this->getLibraries($libraryIds);
    }
	
	protected function getRequestAuthors($name){
		if(!$name || strlen($name) < 3){
			return null;
		}
		$name = mysqli_real_escape_string($GLOBALS["___mysqli_ston"], $name);

        $authors = $this->cache->get($name);
        if ($authors) {
            $this->authors = $authors;
        } else {
            $authorDao = new Author_Dao();
            $authors = $authorDao->all(Db_Criteria::create()->add(Db_Exp::like('name', $name))->perPage(10));
            $this->cache->set($name, $authors, 600);
        }

        $result = array();;
        foreach ($authors as $a) {
            $result[] = $a->id;
        }
        return $result;
	}

//	protected function getMenuFromApi(){
//        $url="http://api.bibliogorod.ru/api/menu";
//
//        //  Initiate curl
//        $ch = curl_init();
//        // Disable SSL verification
//        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
//        // Will return the response, if false it print the response
//        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//        // Set the url
//        curl_setopt($ch, CURLOPT_URL,$url);
//        // Execute
//        $result=curl_exec($ch);
//        // Closing
//        curl_close($ch);
//
//        return json_decode($result, true);
//    }
}
?>
