<?php
mb_internal_encoding('UTF-8');
error_reporting(E_ALL);
ini_set('display_errors', 1);

define('SITE_DIR', realpath(str_replace(basename(__FILE__), "", __FILE__) . "../") . '/');
require_once SITE_DIR.'atm/Loader.php';
Loader::addToPath(array(SITE_DIR, SITE_DIR.'atm', SITE_DIR.'/lib', SITE_DIR.'/lib/dao', SITE_DIR.'/atm/dao'));

$admin_zone = false;
require_once SITE_DIR.'confs/conf.php';
require_once SITE_DIR.'confs/db.php';

$db = new Db_Mysql_Adapter();
Db_Dao::$db = $db;

$itemDao = new Order_Item_Dao();
$cartDao = new Cart_Dao();
$userDao = new User_Dao();
$bookDao = new Book_Dao();

$judgementDay = '2019-06-06 12:00:00';

// Общее количество забронированных изданий по 2-м фондам
$overallCount = $itemDao->count(Db_Criteria::create(array('status' => Order_Status::NEW_ORDER))->add(Db_Exp::ge('date', $judgementDay)));

// Обработано изданий ветхого фонда
$otherFundCount = $itemDao->count(Db_Criteria::create(array('status' => Order_Status::READY, 'fund_type' => Book_Fund::ALLOTHER)));

// Выдано изданий ветхого фонда
$otherFundTakenCount = $itemDao->count(Db_Criteria::create(array('status' => Order_Status::TAKEN, 'fund_type' => Book_Fund::ALLOTHER))->add(Db_Exp::ge('date', $judgementDay)));

// Издания ветхого фонда, ожидающие обработки
$otherFundAwaitingCount = $itemDao->count(Db_Criteria::create(array('status' => Order_Status::NEW_ORDER, 'fund_type' => Book_Fund::ALLOTHER)));

// Издания ветхого фонда, находящиеся в корзинах пользователей
$otherFundInCartCount = $cartDao->count(Db_Criteria::create(array('fund_type' => Book_Fund::ALLOTHER)));

// Обработано изданий обменного фонда
$exFundReadyCount = $itemDao->count(Db_Criteria::create(array('status' => Order_Status::READY, 'fund_type' => Book_Fund::EXCHANGE)));

// Выдано изданий обменного фонда
$exFundTakenCount = $itemDao->count(Db_Criteria::create(array('status' => Order_Status::TAKEN, 'fund_type' => Book_Fund::EXCHANGE))->add(Db_Exp::ge('date', $judgementDay)));

// Издания обменного фонда, ожидающие обработки
$exFundAwaitingCount = $itemDao->count(Db_Criteria::create(array('status' => Order_Status::NEW_ORDER, 'fund_type' => Book_Fund::EXCHANGE)));

// Издания обменного фонда, находящиеся в корзинах пользователей
$exFundInCartCount = $cartDao->count(Db_Criteria::create(array('fund_type' => Book_Fund::EXCHANGE)));

// Издания, которые пользователи забрали офлайн из ветхого фонда
$otherFundOfflineTaken = $itemDao->all(Db_Criteria::create(array('status' => Order_Status::TAKEN, 'fund_type' => Book_Fund::ALLOTHER))->add(Db_Exp::ge('date', $judgementDay)));
$otherFundOfflineTakenCount = 0;
foreach ($otherFundOfflineTaken as $offlineOrderItem) {
    if (strpos($offlineOrderItem->user->email, "generic") !== false) {
        $otherFundOfflineTakenCount++;
    }
}

// Невостребованные издания
$notTakenBooksCount = $bookDao->count(Db_Criteria::create(array('status' => Book_Status::NOT_TAKEN)));

// Новых зарегистрированных физ. лиц
$newRegisteredUsersCount = $userDao->count(Db_Criteria::create(array('roles' => 2))->add(Db_Exp::ge('registration_date', $judgementDay)));

// Из них зарегистрировались онлайн/оффлайн
$newOnlineRegisteredUsersCount = $userDao->count(Db_Criteria::create(array('roles' => 2))->add(Db_Exp::ge('registration_date', $judgementDay)));
$newOfflineRegisteredUsersCount = $userDao->count(Db_Criteria::create(array('roles' => 7))->add(Db_Exp::ge('registration_date', $judgementDay)));

$newRegisteredUsersCount = (int)$newOnlineRegisteredUsersCount + (int)$newOfflineRegisteredUsersCount;

// Зарегистрировано новых юр.лиц
$newRegisteredLrEntities = $userDao->count(Db_Criteria::create(array('roles' => 11))->add(Db_Exp::ge('registration_date', $judgementDay)));
$newRegisteredEntities = $userDao->count(Db_Criteria::create(array('roles' => 12))->add(Db_Exp::ge('registration_date', $judgementDay)));
$allNewRegisteredEntities = $newRegisteredLrEntities + $newRegisteredEntities;

$statsArray = array(
    'Общее количество забронированных изданий по 2-м фондам' => $overallCount,
    'Обработано изданий ветхого фонда' => $otherFundCount,
    'Выдано изданий ветхого фонда' => $otherFundTakenCount,
    'Издания ветхого фонда, ожидающие обработки' => $otherFundAwaitingCount,
    'Издания ветхого фонда, находящиеся в корзинах пользователей' => $otherFundInCartCount,
    'Обработано изданий обменного фонда' => $exFundReadyCount,
    'Выдано изданий обменного фонда' => $exFundTakenCount,
    'Издания обменного фонда, ожидающие обработки' => $exFundAwaitingCount,
    'Издания обменного фонда, находящиеся в корзинах пользователей' => $exFundInCartCount,
    'Издания, которые пользователи забрали офлайн из ветхого фонда' => $otherFundOfflineTakenCount,
    'Невостребованных изданий' => $notTakenBooksCount,
    'Новых зарегистрированных физ. лиц' => $newRegisteredUsersCount,
    'Из них зарегистрировались онлайн' => $newOnlineRegisteredUsersCount,
    'Из них зарегистрировались офлайн' => $newOfflineRegisteredUsersCount,
    'Зарегистрировано новых юр.лиц' => $allNewRegisteredEntities
);

//Util::mail('', 'auto_stats', "Статистика за период ---", array(
//    'overallCount' => $overallCount,
//    'otherFundCount' => $otherFundCount,
//    'otherFundTakenCount' => $otherFundTakenCount,
//    'otherFundAwaitingCount' => $otherFundAwaitingCount,
//    'otherFundInCartCount' => $otherFundInCartCount,
//    'exFundReadyCount' => $exFundReadyCount,
//    'exFundTakenCount' => $exFundTakenCount,
//    'exFundAwaitingCount' => $exFundAwaitingCount,
//    'exFundInCartCount' => $exFundInCartCount,
//    'otherFundOfflineTakenCount' => $otherFundOfflineTakenCount,
//    'newRegisteredUsersCount' => $newRegisteredUsersCount,
//    'newOnlineRegisteredUsersCount' => $newOnlineRegisteredUsersCount,
//    'newOfflineRegisteredUsersCount' => $newOfflineRegisteredUsersCount,
//    'allNewRegisteredEntities' => $allNewRegisteredEntities
//));

$statsFileName = 'daily_report_' . date('Y-m-d') . '.xls';

function makeStatsFile($statsArray, $statsFileName)
{
    if (!file_exists(SITE_DIR . '/uploads/stats/')) {
        mkdir(SITE_DIR . '/uploads/stats/', 0777, true);
    }
    $f = fopen(SITE_DIR . '/uploads/stats/' . $statsFileName, 'w');

    $view = View_View::getInstance();

    $view->stats = $statsArray;

    fwrite($f, $view->renderFile('layouts/export/stats'));
    fclose($f);
}

makeStatsFile($statsArray, $statsFileName);

$mails = array("a.bukin@mos-razvitie.ru", "v.parfenova@mos-razvitie.ru", "m.degtyar@mos-razvitie.ru", "k.kudashova@mos-razvitie.ru");

foreach ($mails as $mail) {
    Util::mail($mail, 'auto_stats', "Статистика 5-го этапа за " . date('Y-m-d'), array('link_to_file' => $statsFileName));
}

?>
