<?php
mb_internal_encoding('UTF-8');
error_reporting(E_ALL);
ini_set('display_errors', 1);

define('SITE_DIR', realpath(str_replace(basename(__FILE__), "", __FILE__) . "../") . '/');
require_once SITE_DIR.'atm/Loader.php';
Loader::addToPath(array(SITE_DIR, SITE_DIR.'atm', SITE_DIR.'/lib', SITE_DIR.'/lib/dao', SITE_DIR.'/atm/dao'));

$admin_zone = false;
require_once SITE_DIR.'confs/conf.php';
require_once SITE_DIR.'confs/db.php';

$db = new Db_Mysql_Adapter();
Db_Dao::$db = $db;

$orderDao = new Order_Dao();
$itemDao = new Order_Item_Dao();
$orderLogDao = new Order_Log_Dao();
$bookDao = new Book_Dao();

$orders = $orderDao->all(Db_Criteria::create(array('status' => Order_Status::EXPIRED))->add(Db_Exp::lt('reserved_untill', date('Y-m-d H:i:s', strtotime(' - 1 days')))));

echo "dismiss_orders STARTED\n";
foreach($orders as $order){
	$orderDao->update($order->id, array('status' => Order_Status::DISMISSED));
	$items = $itemDao->all(Db_Criteria::create(array('order_id' => $order->id, 'status' => Order_Status::EXPIRED)));
	if(!$items){
		continue;
	}
	$bookIds = array();
        $libraries = array();
	foreach($items as $item){
        $libraries[$item->library_id] = $item->library_id;
		$bookIds[] = $item->book_id;

        /**
         * Logging Order Item status when book was EXPIRED and becomes DISMISSED
         */
        $orderLogDao->insert(array('order_id' => $item->order_id, 'book_id' => $item->book_id, 'status_1' => Order_Status::EXPIRED, 'status_2' => Order_Status::DISMISSED, 'created_at' => date("Y-m-d H:i:s")));

        if ($order->fund_type == 2) {
            $bookDao->update($item->book_id, array('status' => Book_Status::ACTIVE));
        }

		$itemDao->update($item->id, array('status' => Order_Status::DISMISSED));
	}
}
echo "dismiss_orders FINISHED\n";
?>