<?php
mb_internal_encoding('UTF-8');
error_reporting(E_ALL);
ini_set('display_errors', 1);

define('SITE_DIR', realpath(str_replace(basename(__FILE__), "", __FILE__) . "../") . '/');
require_once SITE_DIR.'atm/Loader.php';
Loader::addToPath(array(SITE_DIR, SITE_DIR.'atm', SITE_DIR.'/lib', SITE_DIR.'/lib/dao', SITE_DIR.'/atm/dao'));

$admin_zone = false;
require_once SITE_DIR.'confs/conf.php';
require_once SITE_DIR.'confs/db.php';

$db = new Db_Mysql_Adapter();
Db_Dao::$db = $db;

$cartDao = new Cart_Dao();
$bookDao = new Book_Dao();

/**
 * Clears cart with Exchange Fund when 8 hours has passed
 */
//$entityItems = $cartDao->all(Db_Criteria::create()->sql("select c.*, u.roles from cart c left join users u on user_id = u.id where c.fund_type = 2 and date + interval 8 hour < now() and roles like '%11%'"));
$entityItems = $cartDao->all(Db_Criteria::create(array('fund_type' => '2'))->add(Db_Exp::sql("date + interval 8 hour < now()")));
foreach($entityItems as $entityItem){
    $bookDao->update($entityItem->book_id, array('status' => Book_Status::ACTIVE));
//    $bookDao->update($entityItem->book_id, array('status' => Book_Status::NOT_TAKEN));
    $cartDao->delete($entityItem->id);
}

/**
 * Clears All Other Fund cart when 3 hours has passed
 */
//$hours = Presets_Dao::fetch('cart_expiration', 3);
//$items = $cartDao->all(Db_Criteria::create()->add(Db_Exp::sql("date + interval $hours hour < now()")));
$items = $cartDao->all(Db_Criteria::create(array('fund_type' => '1'))->add(Db_Exp::sql("date + interval 3 hour < now()")));

foreach($items as $item){
	$bookDao->update($item->book_id, array('status' => Book_Status::ACTIVE));
//	$bookDao->update($item->book_id, array('status' => Book_Status::NOT_TAKEN));
	$cartDao->delete($item->id);
}

?>
