<?php
mb_internal_encoding('UTF-8');
error_reporting(E_ALL);
ini_set('display_errors', 1);

define('SITE_DIR', realpath(str_replace(basename(__FILE__), "", __FILE__) . "../") . '/');
require_once SITE_DIR.'atm/Loader.php';
Loader::addToPath(array(SITE_DIR, SITE_DIR.'atm', SITE_DIR.'/lib', SITE_DIR.'/lib/dao', SITE_DIR.'/atm/dao'));

$admin_zone = false;
require_once SITE_DIR.'confs/conf.php';
require_once SITE_DIR.'confs/db.php';

$db = new Db_Mysql_Adapter();
Db_Dao::$db = $db;

$libraryDao = new Library_Dao();
$orderDao = new Order_Dao();
$itemDao = new Order_Item_Dao();
$bookDao = new Book_Dao();

$orders = $orderDao->all(Db_Criteria::create(array('status' => Order_Status::READY, 'expiration_notified' => 0))->add(Db_Exp::sql('date(reserved_untill) = date(now() + interval 1 day)')));
foreach($orders as $order){
	$orderDao->update($order->id, array('expiration_notified' => 1));
	$user = $order->user;
	if($user == null){
		continue;
	}
	$items = $itemDao->all(Db_Criteria::create(array('order_id' => $order->id, 'status' => Order_Status::READY)));
	if(!$items){
		continue;
	}
	$bookIds = array();
	foreach($items as $item){
		$bookIds[] = $item->book_id;
	}
	
	Util::mail($user->email, 'expire_notification', "Срок действия заказа № {$order->id} истекает завтра", array('order' => $order, 'items' => $items, 'authors' => Util::getAuthors($bookIds, $authorDao)));
}
?>