<?php
mb_internal_encoding('UTF-8');
error_reporting(E_ALL);
ini_set('display_errors', 1);

define('SITE_DIR', realpath(str_replace(basename(__FILE__), "", __FILE__) . "../") . '/');
require_once SITE_DIR.'atm/Loader.php';
Loader::addToPath(array(SITE_DIR, SITE_DIR.'atm', SITE_DIR.'/lib', SITE_DIR.'/lib/dao', SITE_DIR.'/atm/dao'));

$admin_zone = false;
require_once SITE_DIR.'confs/conf.php';
require_once SITE_DIR.'confs/db.php';

$db = new Db_Mysql_Adapter();
Db_Dao::$db = $db;

$libraryDao = new Library_Dao();
$orderDao = new Order_Dao();
$itemDao = new Order_Item_Dao();
$orderLogDao = new Order_Log_Dao();
$bookDao = new Book_Dao();
$userDao = new User_Dao();
$authorDao = new Author_Dao();

$orders = $orderDao->all(Db_Criteria::create(array('status' => Order_Status::READY))
    ->add(Db_Exp::lt('reserved_untill', date('Y-m-d H:i:s'))));

echo "expire_orders STARTED\n";
foreach($orders as $order){
    $orderDao->update($order->id, array('status' => Order_Status::EXPIRED));
    $items = $itemDao->all(Db_Criteria::create(array('order_id' => $order->id, 'status' => Order_Status::READY)));
    if(!$items){
        continue;
    }
    $bookIds = array();
    $libraries = array();
    foreach($items as $item){
        $libraries[$item->library_id] = $item->library_id;
        $bookIds[] = $item->book_id;

        /**
         * Logging Order Item status if book was READY but it has EXPIRED
         */
        $orderLogDao->insert(array('order_id' => $item->order_id, 'book_id' => $item->book_id, 'status_1' => Order_Status::READY, 'status_2' => Order_Status::EXPIRED, 'created_at' => date("Y-m-d H:i:s")));

        $bookDao->update($item->book_id, array('status' => Book_Status::NOT_TAKEN));
        $itemDao->update($item->id, array('status' => Order_Status::EXPIRED));
    }
    $user = $userDao->get($order->user_id);
    if($user == null){
        continue;
    }
    Util::mail($user->email, 'orders_expired', "Срок действия заказа № {$order->id} истек", array('order' => $order));
    notifyLibraries($userDao, $libraries, $order);
}
echo "expire_orders FINISHED\n";

function notifyLibraries($userDao, $libraries, $order) {
    foreach($libraries as $k => $library_id) {
        $user = $userDao->one(Db_Criteria::create(array('library_id' => $library_id)));
        Util::mail($user->email, 'orders_expired', "Срок действия заказа № {$order->id} истек", array('order' => $order));
        echo "Message to library: " . $library_id . " ORDER: " . $order->id . "\n";
    }
}
?>
