<?php
mb_internal_encoding('UTF-8');
error_reporting(E_ALL);
ini_set('display_errors', 1);

define('SITE_DIR', realpath(str_replace(basename(__FILE__), "", __FILE__) . "../") . '/');
require_once SITE_DIR.'atm/Loader.php';
Loader::addToPath(array(SITE_DIR, SITE_DIR.'atm', SITE_DIR.'/lib', SITE_DIR.'/lib/dao', SITE_DIR.'/atm/dao'));

$admin_zone = false;
require_once SITE_DIR.'confs/conf.php';
require_once SITE_DIR.'confs/db.php';

$db = new Db_Mysql_Adapter();
Db_Dao::$db = $db;

$libraryDao = new Library_Dao();
$orderDao = new Order_Dao();
$itemDao = new Order_Item_Dao();
$orderLogDao = new Order_Log_Dao();
$bookDao = new Book_Dao();
$userDao = new User_Dao();
$authorDao = new Author_Dao();

$orders = $orderDao->all(Db_Criteria::create(array('status' => Order_Status::READY))
    ->add(Db_Exp::lt('reserved_untill', date('Y-m-d H:i:s'))));

echo "holiday_expire_orders STARTED\n";
foreach($orders as $order){
    $orderDao->update($order->id, array('reserved_untill' => date('Y-m-d H:i:s')));
}
echo "holiday_expire_orders FINISHED\n";

?>