<?php
mb_internal_encoding('UTF-8');
error_reporting(E_ALL);
ini_set('display_errors', 1);

define('SITE_DIR', realpath(str_replace(basename(__FILE__), "", __FILE__) . "../") . '/');
require_once SITE_DIR.'atm/Loader.php';
Loader::addToPath(array(SITE_DIR, SITE_DIR.'atm', SITE_DIR.'/lib', SITE_DIR.'/lib/dao', SITE_DIR.'/atm/dao'));

$admin_zone = false;
require_once SITE_DIR.'confs/conf.php';
require_once SITE_DIR.'confs/db.php';

$db = new Db_Mysql_Adapter();
Db_Dao::$db = $db;

$userDao = new User_Dao();

/** First things first, we need to fix all not correct formatted phone numbers */
$setNullToNull = "update ".DB_PREFIX."users SET phone = NULL where phone = ''";
$userDao->sql($setNullToNull);

$setNullToGenerics = "update ".DB_PREFIX."users SET phone = NULL where roles = '7'";
$userDao->sql($setNullToGenerics);

$setNullToLengthNot11 = "update ".DB_PREFIX."users SET phone = NULL where length(phone) < 11";
$userDao->sql($setNullToLengthNot11);

/** @var $users_ncp = Not Correct Phones Users */
$users_ncp = $userDao->all(Db_Criteria::create()
                        ->add(Db_Exp::isNotNull('phone'))
                        ->add(Db_Exp::ne('length(phone)', 11)));

foreach ($users_ncp as $user_ncp) {
    $correctPhone = preg_replace('/[^\d]/', '', $user_ncp->phone);
    $userDao->update($user_ncp->id, array('phone' => "7" . $correctPhone));;
}

/** @var $users_cp = Correct Phones Users */
$users_cp = $userDao->all(Db_Criteria::create()
                        ->add(Db_Exp::isNotNull('phone'))
                        ->add(Db_Exp::eq('length(phone)', 11))
                        ->order(Db_Exp::orderBy('phone', 'asc'))
                        ->order(Db_Exp::orderBy('registration_date', 'desc')));

$phoneBuffer = null;
foreach ($users_cp as $user_ncp) {
    if ($user_ncp->phone === $phoneBuffer) {
        $userDao->update($user_ncp->id, array('phone' => null));
    }
    $phoneBuffer = $user_ncp->phone;
}

?>