<?php
define('SITE_DIR', realpath(str_replace(basename(__FILE__), "", __FILE__) . "../") . '/');
$running = null;
exec("/usr/bin/pgrep -fl mailer.php | grep php", $running);
if(count($running) > 1){
        #file_put_contents(SITE_DIR . '/logs/mailer.log', json_encode($running));
        echo json_encode($running);
	echo "script is in progress \n";
        exit();
}


mb_internal_encoding('UTF-8');
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once SITE_DIR.'atm/Loader.php';
Loader::addToPath(array(SITE_DIR, SITE_DIR.'atm', SITE_DIR.'/lib', SITE_DIR.'/lib/dao', SITE_DIR.'/atm/dao'));

$admin_zone = false;
require_once SITE_DIR.'confs/conf.php';
require_once SITE_DIR.'confs/db.php';

$db = new Db_Mysql_Adapter();
Db_Dao::$db = $db;

$dao = new Mail_Dao();
$mailItems = $dao->all(Db_Criteria::create(array('processed' => 0))->add(Db_Exp::sql("(started_at is null or started_at + interval 10 minute < now())"))->order('date desc')->perPage(150));
foreach($mailItems as $mailItem){
    $dao->update($mailItem->id, array('started_at' => date('Y-m-d H:i:s')));
}
foreach($mailItems as $mailItem)
{
#    try{
        if($mailItem->type == 'order'){
            $ids = json_decode($mailItem->data);
            $bookDao = new Book_Dao();
            $authorDao= new Author_Dao();
            $userDao = new User_Dao();
            $books = $bookDao->get($ids);
            $authors = Util::getAuthors($ids, $authorDao);
                Util::mail($mailItem->email, 'order', 'Вы оформили заказ на портале “Списанные книги”', array('books' => $books, 'authors' => $authors));
            $map = array();
            foreach($books as $book){
                if(!isset($map[$book->library_id])){
                    $map[$book->library_id] = array();
                }
                $map[$book->library_id][] = $book;
            }
            foreach($map as $lid => $bks){
                $u = $userDao->one(Db_Criteria::create(array('library_id' => $lid)));
                if($u == null){
                    continue;
                }
                Util::mail($u->email, 'library_notification', 'Заказ на портале “Списанные книги”', array('books' => $bks, 'authors' => $authors));
            }
        } else if($mailItem->type == 'entityorder'){
            $ids = json_decode($mailItem->data);
            $bookDao = new Book_Dao();
            $authorDao= new Author_Dao();
            $userDao = new User_Dao();
            $books = $bookDao->get($ids);            $authors = Util::getAuthors($ids, $authorDao);
            $authors = Util::getAuthors($ids, $authorDao);
            Util::mail($mailItem->email, 'entityorder', 'Вы оформили заказ на портале “Списанные книги”', array('books' => $books, 'authors' => $authors));
            $map = array();
            foreach($books as $book){
                if(!isset($map[$book->library_id])){
                    $map[$book->library_id] = array();
                }
                $map[$book->library_id][] = $book;
            }
            foreach($map as $lid => $bks){
                $u = $userDao->one(Db_Criteria::create(array('library_id' => $lid)));
                if($u == null){
                    continue;
                }
                Util::mail($u->email, 'library_notification', 'Заказ на портале “Списанные книги”', array('books' => $bks, 'authors' => $authors));
            }
        } else if($mailItem->type == 'confirm') {
            $data = json_decode($mailItem->data);
            $orderDao = new Order_Dao();
            $order = $orderDao->get($data->order_id);

            $itemDao = new Order_Item_Dao();
            $items = $itemDao->all(Db_Criteria::create(array('order_id' => $order->id))->order('id asc'));

            $bookIds = array();
            $valid = array();
            $absent = array();
            foreach ($items as $item) {
                $bookIds[] = $item->book_id;
                if ($item->status == Order_Status::READY) {
                    $valid[] = $item;
                } else {
                    $absent[] = $item;
                }
            }

            $libraries = [];
            foreach ($valid as $item){
                $libraries[$item->library->id]['library'] = $item->library;
                $libraries[$item->library->id]['name'] = $item->library->name;
                $libraries[$item->library->id]['books'][] = $item->book;
            }

            $authorDao = new Author_Dao();
            $emailData = array('valid' => $valid, 'absent' => $absent, 'order' => $order, 'authors' => Util::getAuthors($bookIds, $authorDao), 'libraries' => $libraries);

            Util::mail($mailItem->email, 'order_confirmed', "Ваш заказ №" . $order->id . " готов", $emailData);

            if ($order->user->phone) {
                Util::sms($order->user->phone, "Заказ № " . $order->id . " готов. Книги ждут Вас до " . date("d.m.Y", strtotime($order->reserved_untill)) . " включительно.");
            }

        } else if($mailItem->type == 'enconfirm'){
            $data = json_decode($mailItem->data);
            $orderDao = new Order_Dao();
            $order = $orderDao->get($data->order_id);

            $itemDao = new Order_Item_Dao();
            $items = $itemDao->all(Db_Criteria::create(array('order_id' => $order->id))->order('id asc'));

            $bookIds = array();
            $valid = array();
            $absent = array();
            foreach($items as $item){
                $bookIds[] = $item->book_id;
                if($item->status == Order_Status::READY){
                    $valid[] = $item;
                }else{
                    $absent[] = $item;
                }
            }

            $libraries = [];
            foreach ($valid as $item){
                $libraries[$item->library->id]['library'] = $item->library;
                $libraries[$item->library->id]['name'] = $item->library->name;
                $libraries[$item->library->id]['books'][] = $item->book;
            }

            $authorDao = new Author_Dao();
            $emailData = array('valid' => $valid, 'absent' => $absent, 'order' => $order, 'authors' => Util::getAuthors($bookIds, $authorDao), 'libraries' => $libraries);

            Util::mail($mailItem->email, 'en_order_confirmed', "Ваш заказ № " . $order->id . " готов", $emailData);

            if($order->user->phone){
                Util::sms($order->user->phone, "Заказ № " . $order->id . " готов. Книги ждут Вас до " . date("d.m.Y", strtotime($order->reserved_untill)) . " включительно.");
            }

        } else if($mailItem->type == 'review'){
            $data = json_decode($mailItem->data);
            $orderDao = new Order_Dao();
            $order = $orderDao->get($data->order_id);
            
            $libraryDao = new Library_Dao();
            $library = $libraryDao->get($data->library_id);
            
            $userDao = new User_Dao();
            Util::mail($order->user->email, 'review', "Оцените качество обслуживания в библиотеке", array('library' => $library, 'reviewId' => $data->review_id, 'token' => $userDao->getToken($order->user)));
        } else if($mailItem->type == 'registration'){
            $data = json_decode($mailItem->data, true);
            Util::mail($mailItem->email, 'registration', "Добро пожаловать на портал “Списанные книги”", $data);
        } else if($mailItem->type == 'resendreg'){
            $data = json_decode($mailItem->data, true);
            Util::mail($mailItem->email, 'registration', "Добро пожаловать на портал “Списанные книги”", $data);
        } else if($mailItem->type == 'reset'){
            $data = json_decode($mailItem->data, true);
            Util::mail($mailItem->email, 'reset', "Восстановление пароля на портале “Списанные книги”", $data);
        } else if($mailItem->type == 'change'){
            $data = json_decode($mailItem->data, true);
            Util::mail($mailItem->email, 'change', "Изменение пароля на портале “Списанные книги”", $data);
        } else if($mailItem->type == 'decline'){
            $data = json_decode($mailItem->data, true);
            Util::mail($mailItem->email, 'decline', "Ваша заявка на регистрацию на портале “Списанные книги” отклонена", $data);
        } else if($mailItem->type == 'entityconfirm'){
            $data = json_decode($mailItem->data, true);
            Util::mail($mailItem->email, 'entityconfirm', "Ваша заявка на регистрацию на портале “Списанные книги” одобрена", $data);
        } else if($mailItem->type == 'entityreg'){
            $data = json_decode($mailItem->data, true);
            Util::mail($mailItem->email, 'entityreg', "Заявка на регистрацию организации", $data);
        } else if($mailItem->type == 'entityreg2'){
            $data = json_decode($mailItem->data, true);
            Util::mail($mailItem->email, 'entityreg2', "Заявка на регистрацию организации", $data);
        }
        
#    }catch(Exception $e){
#        error_log($e->message);
#        echo $e->message;
#    }
    $dao->update($mailItem->id, array('processed' => 1));    
}
?>
