<?php
mb_internal_encoding('UTF-8');
error_reporting(E_ALL);
ini_set('display_errors', 1);

define('SITE_DIR', realpath(str_replace(basename(__FILE__), "", __FILE__) . "../") . '/');
require_once SITE_DIR.'atm/Loader.php';
Loader::addToPath(array(SITE_DIR, SITE_DIR.'atm', SITE_DIR.'/lib', SITE_DIR.'/lib/dao', SITE_DIR.'/atm/dao'));

$admin_zone = false;
require_once SITE_DIR.'confs/conf.php';
require_once SITE_DIR.'confs/db.php';

$db = new Db_Mysql_Adapter();
Db_Dao::$db = $db;

$bookDao = new Book_Dao();
$categoryDao = new Book_Category_Dao();
$typeDao = new Book_Type_Dao();
$ageDao = new Book_Age_Dao();
$libraryDao = new Library_Dao();

$categories = $categoryDao->all();
$types = $typeDao->all();
$ages = $ageDao->all();
$libraries = $libraryDao->all();

/**
 * Setting memcached server
 */
$cacheServer = new Memcached();
$cacheServer->addServer("127.0.0.1", 11211);

foreach ($categories as $category) {
    $_booksCountAll = $bookDao->count(Db_Criteria::create(array('status' => Book_Status::ACTIVE, 'published' => 1, 'category_id' => $category->id)));
    $_booksCountMain = $bookDao->count(Db_Criteria::create(array('status' => Book_Status::ACTIVE, 'published' => 1, 'category_id' => $category->id, 'fund_type' => 1)));
    $categoryDao->update($category->id, array('books_count' => $_booksCountAll, 'books_count_main' => $_booksCountMain));
}
$cacheServer->delete("plainCategories");
$cacheServer->delete("plainCategoriesMain");

foreach ($types as $type) {
    $_booksCountAll = $bookDao->count(Db_Criteria::create(array('status' => Book_Status::ACTIVE, 'published' => 1, 'type_id' => $type->id)));
    $_booksCountMain = $bookDao->count(Db_Criteria::create(array('status' => Book_Status::ACTIVE, 'published' => 1, 'type_id' => $type->id, 'fund_type' => 1)));
    $typeDao->update($type->id, array('books_count' => $_booksCountAll, 'books_count_main' => $_booksCountMain));
}
$cacheServer->delete("plainTypes");
$cacheServer->delete("plainTypesMain");

foreach ($ages as $age) {
    $_booksCountAll = $bookDao->count(Db_Criteria::create(array('status' => Book_Status::ACTIVE, 'published' => 1, 'age_category_id' => $age->id)));
    $_booksCountMain = $bookDao->count(Db_Criteria::create(array('status' => Book_Status::ACTIVE, 'published' => 1, 'age_category_id' => $age->id, 'fund_type' => 1)));
    $ageDao->update($age->id, array('books_count' => $_booksCountAll, 'books_count_main' => $_booksCountMain));
}
$cacheServer->delete("plainAges");
$cacheServer->delete("plainAgesMain");

foreach ($libraries as $library) {
    $_hasBooks = $bookDao->one(Db_Criteria::create(array('status' => Book_Status::ACTIVE, 'published' => 1, 'library_id' => $library->id)));
    $libraryDao->update($library->id, array('has_books' => ($_hasBooks ? true : false)));
}
$cacheServer->delete("allLibraries");

?>