<?php
class Cart
{
	private $dao;

	private $bookDao;
	
	private $name = "cart";
	
	private $uid = null;
	
	private $cli = false;
	
	public function __construct($cli = false){
		$this->dao = new Cart_Dao();
        $this->bookDao = new Book_Dao();
        $this->currentUser = Auth_Auth::getUser();
        $this->cli = $cli;
		if(!$cli){
//			if(isset($_COOKIE[$this->name])){
			if($this->currentUser){
//				$this->uid = mysqli_real_escape_string($GLOBALS["___mysqli_ston"], $_COOKIE[$this->name]);
                $this->uid = $this->currentUser->id;
			}else{
//				$this->uid = uniqid();
                $this->uid = null;
			}
			setcookie($this->name, $this->uid, time() + 30 * 24 * 3600);
		}
	}
	
	public function get(){
		$items = $this->dao->all(Db_Criteria::create(array('uid' => $this->uid)));
		if($items){
			$ids = array();
			foreach($items as $item){
				$ids[] = $item->book_id;
			}
			return $ids;
		}
		return null;
	}

	public function countAllOther(){
	    return $this->dao->count(Db_Criteria::create(array('uid' => $this->uid, 'fund_type' => 1)));
    }

    public function countExchange(){
        return $this->dao->count(Db_Criteria::create(array('uid' => $this->uid, 'fund_type' => 2)));
    }

    public function timeLeft(){
        $cartItem = $this->dao->one(Db_Criteria::create(array('uid' => $this->uid)));

//        $timeAdded = $this->dao->one(Db_Criteria::create(array('uid' => $this->uid)))->date;
//        $userRole = $this->dao->one(Db_Criteria::create()->sql("select c.uid, u.roles from cart c left join users u on user_id = u.id where c.uid = '". $this->uid . "';"));

        $now = new DateTime();

//        if (strpos($userRole->roles, '11') !== false) {
        if ($cartItem->fund_type == 2) {
            $timeFinish = DateTime::createFromFormat('Y-m-d H:i:s', $cartItem->date)->add(new DateInterval('PT8H'));
        } else {
            $timeFinish = DateTime::createFromFormat('Y-m-d H:i:s', $cartItem->date)->add(new DateInterval('PT3H'));
        }

        $timeLimit = $timeFinish->diff($now);
        if($timeLimit->invert == 1) {
            $timeLimit = $timeLimit->format('%h час %i мин');
        } else {
            $timeLimit = 'время истекло';
        }
        return $timeLimit;
    }
	
//	public function add($bookId, $libraryId, $fundType){
//		$existing = $this->dao->one(Db_Criteria::create(array('book_id' => $bookId)));
//		if(!$existing){
//			return $this->dao->insert(array('uid' => $this->uid, 'book_id' => $bookId, 'library_id' => $libraryId, 'date' => date('Y-m-d H:i:s'), 'fund_type' => $fundType));
//		}
//		return null;
//	}

    public function add($bookId, $libraryId, $fundType, $currentUser){
        $existing = $this->dao->one(Db_Criteria::create(array('book_id' => $bookId)));
        if(!$existing && $currentUser){
            $this->checkOtherBooksFund($fundType);
            $this->checkOtherLibraryBooks($libraryId, $currentUser);
            $res = $this->dao->insert(array(
                'uid' => $this->uid,
                'book_id' => $bookId,
                'library_id' => $libraryId,
                'date' => date('Y-m-d H:i:s'),
                'fund_type' => $fundType,
                'user_id' => $currentUser->id));
            if ($res) {
                $this->bookDao->update($bookId, array('status' => Book_Status::CART));
            }
            return $res;
        }
        return null;
    }

    /**
     * Removes books by fund type if other type was added to cart
     */
    private function checkOtherBooksFund($fundType) {
        $otherBooksFund = $this->dao->all(Db_Criteria::create(array(
            'uid' => $this->uid,
            'fund_type' => $fundType == 1 ? 2 : 1)));
        foreach ($otherBooksFund as $cartBook) {
            $this->bookDao->update($cartBook->book_id, array('status' => Book_Status::ACTIVE));
        }
        if (count($otherBooksFund) > 0) {
            $this->dao->deleteByCriteria(Db_Criteria::create(array(
                'uid' => $this->uid,
                'fund_type' => $fundType == 1 ? 2 : 1)));
        }
    }

    /**
     * Removes books by library_id if other library's book was added to cart
     */
    private function checkOtherLibraryBooks($libraryId, $currentUser) {
        $criteria = Db_Criteria::create(array('uid' => $this->uid));
            if($libraryId != $currentUser->library_id){
                $criteria->add(Db_Exp::eq('library_id', $currentUser->library_id));
            } else {
                $criteria->add(Db_Exp::ne('library_id', $currentUser->library_id));
            }
        $otherLibBooks = $this->dao->all($criteria);

        foreach ($otherLibBooks as $cartBook) {
            $this->bookDao->update($cartBook->book_id, array('status' => Book_Status::ACTIVE));
        }

        if (count($otherLibBooks) > 0) {
            $criteria = Db_Criteria::create(array('uid' => $this->uid));
                if($libraryId != $currentUser->library_id){
                    $criteria->add(Db_Exp::eq('library_id', $currentUser->library_id));
                } else {
                    $criteria->add(Db_Exp::ne('library_id', $currentUser->library_id));
                }
            $this->dao->deleteByCriteria($criteria);
        }
    }

    public function remove($bookId){
		if($this->cli){
			$this->dao->deleteByCriteria(Db_Criteria::create(array('book_id' => $bookId)));
		}else{
			$this->dao->deleteByCriteria(Db_Criteria::create(array('uid' => $this->uid, 'book_id' => $bookId)));
		}
	}
	
	public function clear(){
		$this->dao->deleteByCriteria(Db_Criteria::create(array('uid' => $this->uid)));
	}

	public function getFundType() {
	    $book = $this->dao->one(Db_Criteria::create(array('uid' => $this->uid)));
	    if ($book) {
	        return $book->fund_type;
        }

        return null;
    }
}
?>