<?php
class Util
{
    private static $translateTable = array(
        "а" => "a", "б" => "b", "в" => "v", "г" => "g", "д" => "d", "е" => "e", "ё" => "e", "ж" => "zh", "з" => "z", "и" => "i", "й" => "y", 
        "к" => "k", "л" => "l", "м" => "m", "н" => "n", "о" => "o", "п" => "p", "р" => "r", "с" => "s", "т" => "t", "у" => "u", "ф" => "f", 
        "х" => "kh", "ц" => "ts", "ч" => "ch", "ш" => "sh", "щ" => "shch", "ы" => "y", "ъ" => "", "ь" => "", "э" => "y", "ю" => "yu", "я" => "ya", " " => "-"
    );
    
    
    public static function validateLogin ($login)
    {
        return preg_match('/^[a-zA-Z\\$_()%0-9=~\\[\\]]{6,}$/', $login);
    }
    
    public static function validateEmail($email)
    {
        return preg_match('/^[a-z0-9+._-]+@[a-z0-9+.-]+\.[a-z]{2,}$/i', $email);
    }

    public static function generatePassword ($length = 9, $strength = 4)
    {
        $vowels = 'aeuy';
        $consonants = 'bdghjmnpqrstvz';
        if ($strength & 1)
            $consonants .= 'BDGHJLMNPQRSTVWXZ';
        if ($strength & 2)
            $vowels .= "AEUY";
        if ($strength & 4)
            $consonants .= '23456789';
        if ($strength & 8)
            $consonants .= '@#$%';
        $password = '';
        $alt = time() % 2;
        for ($i = 0; $i < $length; $i ++) {
            if ($alt == 1) {
                $password .= $consonants[(rand() % strlen($consonants))];
                $alt = 0;
            } else {
                $password .= $vowels[(rand() % strlen($vowels))];
                $alt = 1;
            }
        }
        return $password;
    }
    
    public static function generateCode()
    {
        $code = "";
        for($i = 0; $i < 5; $i++){
            $ch = rand(1, 20);
            if($ch < 10)
                $ch  = "0$ch";
            $code .= "".$ch;
        }
        return $code;
    }
    
    public static function translit($str){
        $result = "";
        for($i = 0; $i < mb_strlen($str); $i++){
            $symb = mb_substr($str, $i, 1);
            
            if(isset(self::$translateTable[$symb]))
                $result .= self::$translateTable[$symb];
            else
                $result .= $symb;
        }
        return $result;
    }

    public static function get_mailer()
    {
        $mail = new PHPMailer();
        $mail->isSMTP();
        $settings = Config::getInstance()->smtpSettings;
        $mail->Host = $settings['host'];
        $mail->SMTPAuth = true;
        $mail->Username = $settings['user'];
        $mail->Password = $settings['password'];
        $mail->SMTPSecure = '';
        $mail->Port = $settings['port'];
        $mail->CharSet = 'UTF-8';
        $mail->setFrom(Config::getInstance()->fromEmail, Config::getInstance()->fromName);
        $mail->isHTML(true);
        
        return $mail;
    }


    // smtp mailer function
    public static function mail($email, $form, $title, $data = null, $viewFolder = null)
    {
        require_once 'lib/mail/class.phpmailer.php';
        require_once 'lib/mail/class.smtp.php';
        
        $from_mail = Presets_Dao::getPresets()->mail ? Presets_Dao::getPresets()->mail : Config::getInstance()->fromEmail;
        $view = View_View::getInstance();
        if($viewFolder){
            $view->setViewsFolder($viewFolder);
        }
        if($data){
            foreach($data as $key => $value){
                $view->$key = $value;
            }
        }
        $view->config = Config::getInstance();
        $t = $view->renderFile('emails/'.$form);
        
#        $mail = new PHPMailer();
#        $mail->isSMTP();
#        $settings = Config::getInstance()->smtpSettings;
#        $mail->Host = $settings['host'];
#        $mail->SMTPAuth = true;
#        $mail->Username = $settings['user'];
#        $mail->Password = $settings['password'];
#        $mail->SMTPSecure = '';
#        $mail->Port = $settings['port'];
#        $mail->CharSet = 'UTF-8';
#        $mail->setFrom(Config::getInstance()->fromEmail, Config::getInstance()->fromName);
#        $mail->isHTML(true);
        
        $mails = explode(',', $email);
        for($i = 0; $i < count($mails); $i++){
            $success = False;
            $sleep = 1000;        
            $error_count = 0;
            while(!$success){
                try{    
                    $mail = Util::get_mailer();

                    $mail->Subject = $title;
                    $mail->Body = $t;
                    $mail->addAddress(trim($mails[$i]));
                
                    if(!$mail->send()){
                        throw new Exception($mail->ErrorInfo);
                    }
                    $success = True;
                } catch (Exception $e) {
                    $success = False;
                    #error_log("Sleep for ".($sleep/1000000)."s. Error: ".substr($e->getMessage(),0,100)."...");
                    usleep($sleep);
                    $error_count = $error_count+1;
#                    $sleep = $sleep*1.5;
                }
            }
            error_log("Sended".($error_count ? " (".$error_count." att) " : "").": [".$title."] -> [".trim($mails[$i])."]");
        }
        return true;
    }
    // old mailer function
    public static function mail1($email, $form, $title, $data = null, $viewFolder = null)
    {
        $from_mail = Presets_Dao::getPresets()->mail ? Presets_Dao::getPresets()->mail : Config::getInstance()->fromEmail;
        $view = View_View::getInstance();
        if($viewFolder){
            $view->setViewsFolder($viewFolder);
        }
        if($data){
            foreach($data as $key => $value){
                $view->$key = $value;
            }
        }
        $view->config = Config::getInstance();
        $t = $view->renderFile('emails/'.$form);
        
        
        $message = array('html' => $t, 'subject' => $title, 'from_email' => Config::getInstance()->fromEmail, 'from_name' => Config::getInstance()->fromName, 'important' => true);
        $envelope = array('key' => Config::getInstance()->mandrillKey, 'message' => $message, 'async' => true, 'send_at' => date("Y-m-d"));
        
        $mails = explode(',', $email);
        $envelope['message']['to'] = array();
        for($i = 0; $i < count($mails); $i++){
            $envelope['message']['to'][] = array('email' => trim($mails[$i]), 'type' => 'to');
        }
        $url = 'https://mandrillapp.com/api/1.0/messages/send.json';
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($envelope));
        curl_exec($ch);
        curl_close($ch);
        return true;
    }
    
    public static function mail2($email, $form, $title, $data = null, $viewFolder = null)
    {
        $success = true;
        mb_internal_encoding('KOI8-R');
        $from_mail = Presets_Dao::getPresets()->mail ? Presets_Dao::getPresets()->mail : Config::getInstance()->fromEmail;
        $view = View_View::getInstance();
        if($viewFolder){
            $view->setViewsFolder($viewFolder);
        }
        if($data){
            foreach($data as $key => $value){
                $view->$key = $value;
            }
        }
        $view->config = Config::getInstance();
        $t = $view->renderFile('emails/'.$form);
        $t = iconv('UTF-8', 'KOI8-R//TRANSLIT', $t);
        $s = iconv('UTF-8', 'KOI8-R//TRANSLIT', $title);
        $from = iconv('UTF-8', 'KOI8-R//TRANSLIT', Config::getInstance()->fromName);
        $from = mb_encode_mimeheader($from, "KOI8-R", "B")."<$from_mail>";
        $mails = explode(',', $email);
        $mail = Pear_Mail::factory('Sendmail');
        $mime = new Pear_Mime_Mime();
        $mime->_build_params = array('html_charset' =>'KOI8-R', 'text_encoding' => 'KOI8-R', 'text_charset'=>'KOI8-R', 'head_charset'=>'KOI8-R', 'head_encoding' => 'base64', 'html_encoding' => 'KOI8-R');
        $mime->setTXTBody($t);
        $body = $mime->get();
        $hdrs = array( 
            'From' =>  $from,
            'Subject' => $s,
            'Reply-To' => $from_mail
        );
        
        for($i = 0; $i < count($mails); $i++){
            $hdrs = $mime->headers($hdrs);
            if($mail->send(trim($mails[$i]), $hdrs, $body) !== true)
                $success = false;
        }
        return $success;
    }
    
    public static function mail3($email, $form, $title, $data = null, $viewFolder = null)
    {
        $success = true;
        mb_internal_encoding('KOI8-R');
        $from_mail = Presets_Dao::getPresets()->mail ? Presets_Dao::getPresets()->mail : Config::getInstance()->fromEmail;
        $view = View_View::getInstance();
        if($viewFolder){
            $view->setViewsFolder($viewFolder);
        }
        if($data){
            foreach($data as $key => $value){
                $view->$key = $value;
            }
        }
        $view->config = Config::getInstance();
        $t = $view->renderFile('emails/'.$form);
        $t = iconv('UTF-8', 'KOI8-R//TRANSLIT', $t);
        $s = iconv('UTF-8', 'KOI8-R//TRANSLIT', $title);
        $from = iconv('UTF-8', 'KOI8-R//TRANSLIT', Config::getInstance()->fromName);
        $from = mb_encode_mimeheader($from, "KOI8-R", "B")."<$from_mail>";
        
        $headers = "From: $from\r\n";
        $headers .= "Reply-To: $from_mail\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/plain; charset=KOI8-R\r\n";
        $headers .= "Content-Transfer-Encoding: 8bit\r\n";
        
        $mails = explode(',', $email);
        for($i = 0; $i < count($mails); $i++){
            mail(($mails[$i]), "=?KOI8-R?B?".base64_encode($s)."?=", $t, $headers, "-f ".$from_mail);
        }
        return true;
    }
    
    public static function simpleMail($email, $from, $title, $text)
    {
        $success = true;
        mb_internal_encoding('KOI8-R');
        $t = iconv('UTF-8', 'KOI8-R//TRANSLIT', $text);
        $s = iconv('UTF-8', 'KOI8-R//TRANSLIT', $title);
        $mails = explode(',', $email);
        $mail = Pear_Mail::factory('Sendmail');
        $mime = new Pear_Mime_Mime();
        $mime->_build_params = array('html_charset' =>'KOI8-R', 'text_charset'=>'KOI8-R', 'head_charset'=>'KOI8-R', 'head_encoding' => 'base64', 'html_encoding' => 'KOI8-R');
        $mime->setTXTBody($t);
        $body = $mime->get();
        $hdrs = array( 
            'From' => $from,
            'Subject' => $s
        );
        
        for($i = 0; $i < count($mails); $i++){
            $hdrs = $mime->headers($hdrs);
            if($mail->send(trim($mails[$i]), $hdrs, $body) !== true)
                $success = false;
        }
        return $success;
    }
    
    public static function scrubData($data, $fields, $defaults = array())
    {
        $vals = array();
        foreach($defaults as $k=>$v)
            $vals[$k] = trim($v);
        foreach($fields as $f)
            if(isset($data[$f]))
                $vals[$f] = trim($data[$f]);
        return $vals;
    }
    
    public static function filterStr($str)
    {
        if(is_string($str))
            return trim(strip_tags($str));
        return $str;
    }
    
    public static function getAuthorsTitle($map, $bookId, $titles){
        if(!isset($map[$bookId])){
            return '';
        }
        if(count($map[$bookId]) == 1){
            return $titles[0];
        }
        return $titles[1];
    }
    
    public static function getAuthorsStr($map, $bookId, $html = false, $replace = ''){
        if(!isset($map[$bookId])){
            return $replace;
        }
        $list = array();
        foreach($map[$bookId] as $i => $a){
            if($html){
                /**
                 * Alternative version of listing books
                 * $list[] = '<a href="/books/author/' . $a->id . '">' . $a->name . '</a>';
                 */
                $list[] = '<a href="/books?author=' . urlencode($a->name) . '">' . $a->name . '</a>';
            }else{
                $list[] = $a->name;
            }
        }
        return join(', ', $list);
    }
    
    public static function getAuthors(&$bookIds, $authorDao){
        if(!$bookIds){
            return array();
        }
        
        $as = $authorDao->all(Db_Criteria::create()->sql("select book_id, a.* from authors a, books_authors where a.id = author_id and book_id in (".join(',', $bookIds).")"));
        $result = array();
        foreach($as as $a){
            if(!isset($result[$a->book_id])){
                $result[$a->book_id] = array();
            }
            $result[$a->book_id][] = $a;
        }
        return $result;
    }


    public static function getCategoryName($map, $bookId, $replace = ''){
        if(!isset($map[$bookId])){
            return $replace;
        } else {
            return $map[$bookId];
        }
    }

    public static function getCategories(&$bookIds, $categoryDao){
        if(!$bookIds){
            return array();
        }

        $cats = $categoryDao->all(Db_Criteria::create()->sql("select books.id, book_categories.name from books left join book_categories on books.category_id = book_categories.id where books.id in (".join(',', $bookIds).")"));
        $result = array();
        foreach($cats as $c){
            if(!isset($result[$c->id])){
                $result[$c->id] = $c->name;
            }
        }
        return $result;
    }
    
    public static function sms($phone, $message){
        $config = Config::getInstance();
        
        $handler = curl_init();
        
        curl_setopt($handler, CURLOPT_POST, true);
        curl_setopt($handler, CURLOPT_HEADER, false);
        curl_setopt($handler, CURLOPT_URL, $config->smsUrl);
        curl_setopt($handler, CURLOPT_POSTFIELDS, array('login' => $config->smsLogin, 'psw' => $config->smsPassword, 'sender' => $config->smsSender, 'phones' => $phone, 'mes' => $message, 'charset' => 'utf-8'));
        
        curl_setopt($handler, CURLOPT_TIMEOUT, 5);
        curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($handler, CURLOPT_CONNECTTIMEOUT, 5);
        curl_setopt($handler, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($handler, CURLOPT_SSL_VERIFYPEER, false);
        
        $response = curl_exec($handler);
        $error = curl_error($handler);
        $errorCode = curl_errno($handler);
        $info = curl_getinfo($handler);
        
        curl_close($handler);

        error_log("sms to number $phone with text $message. response $response. errors is $error. code is $errorCode");
    }
    
//    public static function getOrderStartTime($date){
//        $time = strtotime($date);
//        $closeTime = strtotime(date("Y-m-d", $time) . ' 19:30:00');//19:30 того же дня
//        if($closeTime < $time){
//            //заказ пришел после 19:30
//            $time = strtotime(date("Y-m-d", $time) . ' 13:00:00 + 1 days');
//        }
//        if(date('w', $time) == 1){
//            //с понедельника переносим на вторник на 13:00
//            $time = strtotime(date("Y-m-d", $time) . ' 13:00:00 + 1 days');
//        }
//        if(date('G') < 13){
//            $time = strtotime(date("Y-m-d", $time) . ' 13:00:00');
//        }
//        return date("Y-m-d H:i:00", $time);
//    }

    public static function getLibraryOrderStartTime($libraryId, $dateTimeNow){
        $orderStartTime = strtotime($dateTimeNow);

        $dayOfWeek = date('w', strtotime($dateTimeNow));

        $libraryDao = new Library_Dao();
        $librarySchedule = $libraryDao->get($libraryId)->schedule;
        $librarySchedule = json_decode($librarySchedule);

        /**
         * Set Monday to array key = 1
         */
        array_unshift($librarySchedule, null);
        unset($librarySchedule[0]);

        /**
         * If Today = weekend day
         */
        if($librarySchedule[$dayOfWeek] === null) {
            $dayCount = 0;
            while ($librarySchedule[$dayOfWeek] === null) {
                $dayCount++;
                $dayOfWeek++;
                if ($dayOfWeek > count($librarySchedule)) {
                    $dayOfWeek = 1;
                }
            }
            $nextWorkDaySchedule = $librarySchedule[$dayOfWeek];

            $libraryOpenTime = explode("-", $nextWorkDaySchedule)[0];

            $result = strtotime(date("Y-m-d", $orderStartTime) . $libraryOpenTime . ' + ' . $dayCount . ' days + 1 hour');

            /**
             * If Today = work day
             */
        }
        elseif($librarySchedule[$dayOfWeek] !== null) {
            $currentWorkDaySchedule = $librarySchedule[$dayOfWeek];

            $libraryOpenTime = explode("-", $currentWorkDaySchedule)[0];
            $libraryCloseTime = substr($librarySchedule[$dayOfWeek], strpos($librarySchedule[$dayOfWeek], "-") + 1);

            if($orderStartTime < strtotime(date("Y-m-d" . ' ' . $libraryOpenTime) . ' + 1 hour')) {
                $result = strtotime(date("Y-m-d" . ' ' . $libraryOpenTime) . ' + 1 hour');
            }
            if($orderStartTime > strtotime(date("Y-m-d" . ' ' . $libraryOpenTime) . ' + 1 hour') && $orderStartTime < strtotime(date("Y-m-d" . ' ' . $libraryCloseTime) . ' - 1 hour')) {
                $result = strtotime(date("Y-m-d H:i:s"));
            }
            if($orderStartTime > strtotime(date("Y-m-d" . ' ' . $libraryCloseTime) . ' - 1 hour')) {
                $dayCount = 1;
                $dayOfWeek++;

                while ($librarySchedule[$dayOfWeek] === null) {
                    $dayCount++;
                    $dayOfWeek++;
                    if ($dayOfWeek > count($librarySchedule)) {
                        $dayOfWeek = 1;
                    }
                }
                $nextWorkDaySchedule = $librarySchedule[$dayOfWeek];

                $libraryOpenTime = explode("-", $nextWorkDaySchedule)[0];

                $result = strtotime(date("Y-m-d", $orderStartTime) . $libraryOpenTime . ' + ' . $dayCount . ' days + 1 hour');
            }
        }

        return date("Y-m-d H:i:00", $result);
    }
}
?>
