<?php
class Book_Dao extends Db_Dao
{
	public function __construct()
    {
		parent::__construct();

		$this->table = "books";
		$this->model = 'Book_Field';
	}

	public function import($externalId, $isbn, $title, $year, $authors, $categoryId, $typeId, $ageId, $libraryId,
                           $inventory, $units, $count, $price, $factor, $totalPrice, $cancelReason, $fundType)
    {
		$existing = $this->one(Db_Criteria::create(array('external_id' => $externalId)));

		$values = [
            'external_id' => $externalId,
		    'isbn' => $isbn,
            'title' => $title,
            'year' => $year,
            'type_id' => $typeId,
            'category_id' => $categoryId,
            'age_category_id' => $ageId,
            'library_id' => $libraryId,
            'inventory' => $inventory,
            'units' => $units,
            'count' => $count,
            'price' => $price,
            'factor' => $factor,
            'total_price' => $totalPrice,
            'cancel_reason' => $cancelReason,
            'fund_type' => $fundType
        ];

		$id = null;
		if ($existing === null) {
			$id = $this->insert($values);
		} else {
			$this->update($existing->id, $values);
			$id = $existing->id;
		}

		if ($id === null) {
			return null;
		}

		/** Assign Book and Authors */
		$linkDao = new Db_Dao();
		$linkDao->table = "books_authors";
		$linkDao->deleteByCriteria(Db_Criteria::create(array('book_id' => $id)));

		foreach ($authors as $author) {
			$linkDao->insert(array('book_id' => $id, 'author_id' => $author));
		}

		return $id;
	}

	public function getInLibrary($libraryId)
    {
		return $this->count(Db_Criteria::create(array('library_id' => $libraryId)));
	}
}

?>