<?php
class Cbs_Dao extends Db_Dao{
	
	public function __construct(){
		parent::__construct();
		$this->table = "cbs_sb";
	}
	
	public function import($externalId, $name){
		$cbsId = null;
		$cbs = $this->one(Db_Criteria::create(array('external_id' => $externalId)));
		if($cbs == null){
			$cbsId = $this->insert(array('external_id' => $externalId, 'name' => $name));
		}else{
			$this->update($cbs->id, array('name' => $name));
			$cbsId = $cbs->id;
		}
		$this->createUser($cbsId, $name);
		return $cbsId;
	}
	
	private function createUser($cbsId, $name){
		$userDao = new User_Dao();
		$login = 'cbs' . $cbsId;
		$existing = $userDao->one(Db_Criteria::create(array('cbs_id' => $cbsId)));
		if($existing != null){
			return;
		}
		$userData = array('login' => $login, 'password' => md5(Util::generatePassword(10)), 'email' => $login . '@generic.gen', 'name' => $name, 'cbs_id' => $cbsId);
		$user = $userDao->register($userData, array(Roles::CBS, Roles::ADMIN));
	}
}

?>