<?php
class Library_Dao extends Db_Dao
{
	public function __construct()
    {
		parent::__construct();

		$this->table = "libraries";
		$this->model = 'Library_Field';
	}

	public function import($name, $externalId, $cbsId, $coords, $address, $schedule,
                           $off, $region, $district, $metro, $userMail, $userPass)
    {
//		$service = mb_strtolower($service);
//		$service = $service == "нет" ? 0 : 1;

		$s = array();
		for ($i = 0; $i < count($schedule); $i++) {
			$day = $schedule[$i];
			if ($day == "Выходной" || $day == "-" || $day == "c 00:00 по 00:00") {
				$s[] = null;
			} else {
				$s[] = trim(str_replace(" по ", "-", str_replace(" до ", "-", str_replace("c", "", trim($day)))));
			}
		}
		$schedule = json_encode($s);
		$existing = $this->getByExternalId($externalId);

		$id = null;
		if ($off == "нет") {
			$off = null;
		}

		$values = [
		    'name' => $name,
            'external_id' => $externalId,
            'cbs_sb_id' => $cbsId,
            'type_id' => null,
            'coords' => $coords,
            'phone' => null,
            'site' => null,
            'address' => $address,
            'postindex' => null,
            'schedule' => $schedule,
            'service' => 1,
            'day_off' => $off,
            'published' => 0,
            'region' => $region,
            'district' => $district,
            'metro' => $metro
        ];

        $id = null;
		if ($existing === null) {
			$id = $this->insert($values);
		} else {
			$id = $existing->id;
			$this->update($id, $values);
		}

        if ($id === null) {
            return null;
        }

		if ($userMail !== null && $userPass !== null) {
		    $this->clearLibraryEmail($userMail);
            $this->createUser($id, $name, $userMail, $userPass);
        }

        return $id;
	}

	public function clearLibraryEmail($userMail)
    {
        $user = new User_Dao();
        $userId = $user->getByEmail($userMail)->id;
        $user->delete($userId);
    }

//	public function import($name, $address, $phone, $site, $service, $typeId, $schedule, $off, $externalId, $cbsId){
//		$site = explode(" ", trim(str_replace("http://", "", $site)));
//		foreach($site as $i => $s){
//			$site[$i] = $s == "" ? "" : "http://$s";
//		}
//		$site = join(", ", $site);
//		$service = mb_strtolower($service);
//		$service = $service == "нет" ? 0 : 1;
//		$s = array();
//		for($i = 0; $i < count($schedule); $i++){
//			$day = $schedule[$i];
//			if($day == "Выходной" || $day == '-' || $day == 'c 00:00 по 00:00'){
//				$s[] = null;
//			}else{
//				$s[] = trim(str_replace(" по ", "-", str_replace("c", "", $day)));
//			}
//		}
//		$schedule = json_encode($s);
//		$existing = $this->getByExternalId($externalId);
//		$id = null;
//		if($off == "нет"){
//			$off = null;
//		}
//		$values = array('name' => $name, 'external_id' => $externalId, 'cbs_sb_id' => $cbsId, 'type_id' => $typeId, 'phone' => $phone, 'site' => $site, 'schedule' => $schedule, 'service' => $service, 'day_off' => $off, 'published' => 0, 'address' => $address);
//		if($existing == null){
//			$id = $this->insert($values);
//		}else{
//			$id = $existing->id;
//			$this->update($id, $values);
//		}
//		if(!$id){
//			return;
//		}
//		$this->createUser($id, $name);
//		return $id;
//	}
	
	public function getByExternalId($externalId){
		return $this->one(Db_Criteria::create(array('external_id' => $externalId)));
	}
	
	private function createUser($libraryId, $name, $userMail, $userPass){
		$userDao = new User_Dao();
		$existing = $userDao->one(Db_Criteria::create(array('library_id' => $libraryId)));
		if($existing != null){
			return;
		}
		$userData = array('login' => $userMail, 'password' => md5($userPass), 'email' => $userMail, 'name' => $name, 'library_id' => $libraryId, 'isblocked' => 0);
		$userDao->register($userData, array(Roles::LIBRARY, Roles::LRENTITY));
	}

//	private function createUser($libraryId, $name){
//		$userDao = new User_Dao();
//		$login = 'lib' . $libraryId;
//		$existing = $userDao->one(Db_Criteria::create(array('library_id' => $libraryId)));
//		if($existing != null){
//			return;
//		}
//		$userData = array('login' => $login, 'password' => md5(Util::generatePassword(10)), 'email' => $login . '@generic.gen', 'name' => $name, 'library_id' => $libraryId, 'isblocked' => 1);
//		$user = $userDao->register($userData, array(Roles::LIBRARY));
//	}
}

?>