<?php
class Library_Field extends Db_Field{
	
	protected $references = array('cbs_sb' => 'Cbs_Dao');
	
	public function getExpiredDate($date, $daysCount){
		$days = json_decode($this->schedule);
		$expired =date("Y-m-d 23:55:00", strtotime($date . " +{$daysCount} days"));
		$day = intval(date("w", strtotime($expired)));
		if($day == 0){
			$day = 6;
		}else{
			$day--;
		}
		$counter = 0;
		while($counter < 7){
			$counter++;
			if(!$days[$day]){
				$expired =date("Y-m-d H:i:s", strtotime($expired . " +1 days"));
			}else{
				break;
			}
			$day++;
			if($day > 6){
				$day = 0;
			}
		}
		if($counter == 7){
			//нет расписания
			$expired = date("Y-m-d 23:55:00", strtotime($date . " +{$daysCount} days"));
		}
		return $expired;
	}
}

?>