<?php
class Order_Dao extends Db_Dao{
	
	public function __construct(){
		parent::__construct();
		$this->table = "orders";
		$this->model = 'Order_Field';
	}

	public function order($userId, &$books, $generic = false){
		$fundType = $books[0]->fund_type;

        /**
         * Creates associative array from books list with Libraries Ids as keys
         */
        $booksArr = [];
        foreach($books as $book) {
            $booksArr[$book->library_id][] = $book;
        }

		$dateTimeNow = date("Y-m-d H:i:s");

		$orderIds = [];

        $itemDao = new Order_Item_Dao();
        $bookDao = new Book_Dao();
        $orderLogDao = new Order_Log_Dao();

        /**
         * Creates new Order for each Library in ordered books list
         */
        foreach($booksArr as $libraryId => $booksObjects) {
            $orderId = $this->insert([
                'user_id' => $userId,
                'status' => $generic ? Order_Status::TAKEN : Order_Status::NEW_ORDER,
                'date' => $dateTimeNow,
                'books_count' => count($booksObjects),
                'libraries_count' => 1,
                'taken_at' => $generic ? $dateTimeNow : null,
                'fund_type' => (int)$fundType
            ]);

            /**
             * Creates new Order Items for each book in current Order ($orderId)
             */
            foreach($booksObjects as $i => $book) {
                $itemDao->insert([
                    'order_id' => $orderId,
                    'user_id' => $userId,
                    'book_id' => $book->id,
                    'library_id' => $libraryId,
                    'status' => $generic ? Order_Status::TAKEN : Order_Status::NEW_ORDER,
                    'date' => $dateTimeNow,
                    'taken_at' => $generic ? $dateTimeNow : null,
                    'fund_type' => (int)$book->fund_type
                ]);

                /**
                 * Updates each book status from FREE to RESERVED
                 * If this is Offline order, setting book's status to TAKEN already
                 */
                $bookDao->update($book->id, [
                    'status' => $generic ? Book_Status::TAKEN: Book_Status::RESERVED
                ]);

                /**
                 * Logging each book status change from FREE to NEW_ORDER (book reserved)
                 */
                $orderLogDao->insert([
                    'order_id' => $orderId,
                    'book_id' => $book->id,
                    'status_1' => Order_Status::FREE,
                    'status_2' => $generic ? Order_Status::TAKEN: Order_Status::NEW_ORDER,
                    'created_at' => $dateTimeNow
                ]);
            }

            $orderIds[$libraryId] = $orderId;
        }

        foreach($booksArr as $libraryId => $booksObjects) {
            if(count($booksObjects) !== 0) {
                $firstItem = $itemDao->one(Db_Criteria::create([
                        'order_id' => $orderIds[$libraryId],
                        'status' => Order_Status::NEW_ORDER,
                        'library_id' => $libraryId
                    ])
                    ->order('id asc'));

                if(($firstItem !== null) && (!$firstItem->processing)) {
                    /**
                     * Setting Left time start for Librarian in first Order Item
                     */
                    $left_time_start = Util::getLibraryOrderStartTime($libraryId, $dateTimeNow);

                    $itemDao->update($firstItem->id, ['left_time_start' => $left_time_start]);
                }
            }
		}

		return $generic ? $orderIds[$books[0]->library_id] : $orderIds;
	}

	public function expired($order){
	    $userDao = new User_Dao();
	    $userRoles = $userDao->one(Db_Criteria::create(array('id' => $order->user_id)))->roles;

	    if (in_array("11", $userRoles)) {
	        $resDays = 14;
        } else {
	        $resDays = 3;
        }

		$date = date("Y-m-d H:i:s");
		$expired = date("Y-m-d 23:55:00", strtotime($date . " +" . Presets_Dao::fetch('order_reservation_days', $resDays) . " days"));
		$this->update($order->id, array('reserved_untill' => $expired));
	}
	
	public function extend($order, $days){
		$expired = date("Y-m-d 23:55:00", strtotime($order->reserved_untill . " +{$days} days"));
		$this->update($order->id, array('reserved_untill' => $expired, 'extend_count' => $order->extend_count + 1, 'expiration_notified' => 0));
	}

    public function manualExtend($order, $days){
        $expired = date("Y-m-d 23:55:00", strtotime($order->reserved_untill . " +{$days} days"));
        $this->update($order->id, array('reserved_untill' => $expired, 'expiration_notified' => 0));
    }

//	public function getDayOrderCount($userId){
//		$itemDao = new Order_Item_Dao();
//		$date = date('Y-m-d');
//		return $itemDao->count(Db_Criteria::create(array('user_id' => $userId))->add(Db_Exp::sql("date(date) = '{$date}'")));
//	}

	public function getBooksCount($userId){
        $itemDao = new Order_Item_Dao();
        $date = date('Y-m-d');

        return $itemDao->count(Db_Criteria::create(array('user_id' => $userId, 'fund_type' => 1))->add(Db_Exp::sql("date(date) = '{$date}'")));
    }

    public function getExBooksCount($userId){
        $itemDao = new Order_Item_Dao();
        $date = date('Y-m-d');

        return $itemDao->count(Db_Criteria::create(array('user_id' => $userId, 'fund_type' => 2))->add(Db_Exp::sql("date(date) = '{$date}'")));
    }
}

?>