<?php
class Order_Item_Field extends Db_Field{
	
	protected $references = array('order' => 'Order_Dao', 'library' => 'Library_Dao', 'book' => 'Book_Dao', 'user' => 'User_Dao');
	
	public function getAuthorsStr($map, $html = false, $replace = ''){
		return Util::getAuthorsStr($map, $this->book_id, $html, $replace);
	}
	
	public function __get($field){
		if($field == 'processing'){
			return $this->left_time_start != null;
		}else if($field == 'left'){
			$dif = strtotime($this->left_time_start) + 1800 - time();//+ 30 min
			if($dif < 0){
				return 0;
			}
			return ceil($dif / 60);
		}else if($field == 'stale'){
			$dif = time() - strtotime($this->left_time_start) - 1800;
			if($dif < 0){
				return 0;
			}
			return ceil($dif / 60);
		}
		return parent::__get($field);
	}
}

?>