<?php
class Review_Dao extends Db_Dao{
	
	public function __construct(){
		parent::__construct();
		$this->table = "reviews";
		$this->model = 'Review_Field';
	}
	
	public function request($order, $item){
		$review = $this->one(Db_Criteria::create(array('value' => 0, 'library_id' => $item->library_id, 'user_id' => $order->user_id)));
		if($review != null){
			//пользователю уже предлагалось оценить библиотеку, но он этого не сделал
			return;
		}
		$review = $this->one(Db_Criteria::create(array('order_number' => $order->id, 'library_id' => $item->library_id, 'user_id' => $order->user_id)));
		if($review != null){
			return;
		}
		$reviewId = $this->insert(array('order_number' => $order->id, 'library_id' => $item->library_id, 'user_id' => $order->user_id));
		$mailDao = new Mail_Dao();
		$data = array('order_id' => $order->id, 'library_id' => $item->library_id, 'review_id' => $reviewId);
		$mailDao->add($order->user->email, 'review', $data);		
	}
	
	public function getPending($user){
		return $this->all(Db_Criteria::create(array('value' => 0, 'user_id' => $user->id))->order('id asc'));
	}
}

?>