<?php 
class Import_Book
{
	private $libraryDao;
	private $bookDao;
	private $bookCategoryDao;
	private $bookTypeDao;
	private $bookAgeDao;
	private $authorDao;

	public function __construct()
    {
		$this->libraryDao = new Library_Dao();
		$this->bookDao = new Book_Dao();
		$this->bookCategoryDao = new Book_Category_Dao();
		$this->bookTypeDao = new Book_Type_Dao();
		$this->bookAgeDao = new Book_Age_Dao();
		$this->authorDao = new Author_Dao();
	}

	public function import(&$parts, $fundType)
    {
        /** Get book parts for import data */
        $externalId = intval($parts[0]);

        $inventory = trim($parts[1]);

        $isbn = trim($parts[2]);

        if (!$parts[3]) {
            $authors = [];
        } else {
            $bookAuthors = trim($parts[3]);
            try {
                $authors = $this->authorDao->import($bookAuthors);
            } catch (Exception $exception) {
                echo "failed import to authors " . join(",", $parts), "\n";
                $this->writeImportLog("$parts[0] не удалось импортировать авторов документа $parts[6]");
            }
        }

        if (!$parts[4]) {
            $title = "-";
		} else {
            $title = trim($parts[4]);
        }

        $year = intval($parts[5]);

        $typeId = $this->bookTypeDao->import($parts[6]);
        if ($typeId === null) {
            echo "failed import to book_types " . join(",", $parts), "\n";
            $this->writeImportLog("$parts[0] не удалось импортировать вид документа $parts[6]");
        }

		$categoryId = $this->bookCategoryDao->import($parts[7]);
		if ($categoryId === null) {
			echo "failed import to book_categories " . join(",", $parts), "\n";
            $this->writeImportLog("$parts[0] не удалось импортировать тематику документа $parts[7]");
		}

		$ageId = $this->bookAgeDao->import($parts[8]);
		if ($ageId === null) {
			echo "failed import to age_categories " . join(",", $parts), "\n";
			$this->writeImportLog("$parts[0] не удалось импортировать возрастную категорию документа $parts[8]");
		}

        $units = trim($parts[9]);

        $count = trim($parts[10]);

        if (!$parts[11]) {
            $price = null;
        } else {
            $price = floatval($parts[11]);
        }

        if (!$parts[12]) {
            $factor = null;
        } else {
            $factor = floatval($parts[12]);
        }

        if (!$parts[13]) {
            $totalPrice = null;
        } else {
            $totalPrice = floatval($parts[13]);
        }

        $cancelReason = trim($parts[14]);

        $parts[18] = trim($parts[18], " \n\r\"");
        preg_match('/[\w\d]+/', $parts[18], $matches);
        $parts[18] = $matches[0];

        /** Attach book to library by External ID */
        $library = $this->libraryDao->getByExternalId($parts[18]);
		if ($library !== null) {
            $libraryId = $library->id;

            $bookId = $this->bookDao
                ->import($externalId, $isbn, $title, $year, $authors, $categoryId, $typeId, $ageId, $libraryId,
                    $inventory, $units, $count, $price, $factor, $totalPrice, $cancelReason, $fundType);
            if (!$bookId) {
                echo "failed to import book " . join(",", $parts), "\n";
                $this->writeImportLog("$parts[0] не удалось импортировать книгу $parts[0] $parts[4]");
            } else {
                echo $externalId . " " . $title . " > success\n";
            }
        } else {
            echo "failed attach book to library " . join(",", $parts), "\n";
            $this->writeImportLog("$parts[0] библиотека не найдена $parts[16]");
        }

		return true;
	}

    public function writeImportLog($logMessage)
    {
        $logDirectory = "logs/";
        if (!file_exists($logDirectory)) {
            mkdir($logDirectory, 0777, true);
        }

        $logFileName = "book_import_log_" . date('d_M_Y') . ".log";
        $logMessage = date('d.m.Y H:i:s') . " " . $logMessage . "\n";

        $logPath = $logDirectory . $logFileName;
        file_put_contents($logPath, $logMessage, FILE_APPEND);
    }
}

?>