<?php 
class Import_Library
{
	private $libraryDao;
	private $libraryTypeDao;
	private $cbsDao;

	public function __construct()
    {
		$this->libraryDao = new Library_Dao();
		$this->libraryTypeDao = new Library_Type_Dao();
		$this->cbsDao = new Cbs_Dao();
	}

    public function download_page($path)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $path);
        curl_setopt($ch, CURLOPT_FAILONERROR, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 15);
        $retValue = curl_exec($ch);
        curl_close($ch);

        return $retValue;
    }

    public function getYMapsCoords($address)
    {
        $config = Config::getInstance();
        $apiKey = $config->yandexAPIkey;
        $apiHost = "https://geocode-maps.yandex.ru/1.x/?apikey=$apiKey&geocode=";
        $setApiAddress = $apiHost . urlencode("г. Москва ".$address);

        $sXML = $this->download_page($setApiAddress);
        $oXML = new SimpleXMLElement($sXML);

        $oXML->registerXPathNamespace('c', 'http://www.opengis.net/gml');
        $result = $oXML->xpath('//c:pos');

        $yCoords =  $result[0];
        $yCoords = explode(" ", $yCoords);

        return $yCoords;
    }

	public function import(&$parts)
    {
//		if (!$parts[18]) {
//			return true;
//		}

        $cbsName = trim($parts[1]);
        $cbsName = (str_replace("г.Москвы", "г. Москвы", $cbsName));
        $cbsId = $this->cbsDao->one(Db_Criteria::create(array('name' => $cbsName)))->id;

		$name = trim($parts[2]);

		$address = trim($parts[3]);

        $coords = implode(",", $this->getYMapsCoords($address));

		$district = $parts[4];

		$region = $parts[5];

		$metro = $parts[6];

		$schedule = array(
		    $parts[7], $parts[8], $parts[9], $parts[10], $parts[11], $parts[12], $parts[13]
        );

		$off = $parts[14];

		$externalId = $parts[15];

        if ($parts[16]) {
            $userMail = trim($parts[16]);
        } else {
            $userMail = null;
        }

        if ($parts[17]) {
            $userPass = trim($parts[17]);
        } else {
            $userPass = null;
        }

		$lId = $this->libraryDao->import($name, $externalId, $cbsId, $coords, $address, $schedule,
                                        $off, $region, $district, $metro, $userMail, $userPass);

		if (!$lId) {
            echo "failed to import library " . join(",", $parts), "\n";
            $this->writeImportLog("$parts[0] не удалось импортировать библиотеку $parts[2]");
		} else {
            echo $parts[0] . " " . trim($parts[2]) . " > success\n";
        }

		return true;
	}

    public function writeImportLog($logMessage)
    {
        $logDirectory = "logs/";
        if (!file_exists($logDirectory)) {
            mkdir($logDirectory, 0777, true);
        }

        $logFileName = "library_import_log_" . date('d_M_Y') . ".log";
        $logMessage = date('d.m.Y H:i:s') . " " . $logMessage . "\n";

        $logPath = $logDirectory . $logFileName;
        file_put_contents($logPath, $logMessage, FILE_APPEND);
    }
}

?>