<?php
class Pear_Mail_Sendmail extends Pear_Mail {

    protected $sendmail_path = '/usr/sbin/sendmail';

    protected $sendmail_args = '-i';

    public function __construct($params)
    {
    	parent::__construct($params);
        if (isset($params['sendmail_path']))
            $this->sendmail_path = $params['sendmail_path'];
        if (isset($params['sendmail_args']))
            $this->sendmail_args = $params['sendmail_args'];
        if (defined('PHP_EOL'))
            $this->sep = PHP_EOL;
        else
            $this->sep = (strpos(PHP_OS, 'WIN') === false) ? "\n" : "\r\n";
    }

    function send($recipients, $headers, $body)
    {
    	if (!is_array($headers))
            throw new Exception('$headers must be an array');
        
        $result = $this->_sanitizeHeaders($headers);
        
        $recipients = $this->parseRecipients($recipients);
        $recipients = escapeShellCmd(implode(' ', $recipients));

        $headerElements = $this->prepareHeaders($headers);
        if (!$headerElements)
            throw new Exception();
        list($from, $text_headers) = $headerElements;

        if (!empty($headers['Return-Path'])) {
            $from = $headers['Return-Path'];
        }

        if (!isset($from)) {
            throw new Exception();
        } elseif (strpos($from, ' ') !== false ||
                  strpos($from, ';') !== false ||
                  strpos($from, '&') !== false ||
                  strpos($from, '`') !== false) {
            throw new Exception('From address specified with dangerous characters.');
        }

        $from = escapeShellCmd($from);
        $mail = @popen($this->sendmail_path . (!empty($this->sendmail_args) ? ' ' . $this->sendmail_args : '') . " -f ".Config::getInstance()->fromEmail." -- $recipients", 'w');
        if (!$mail) {
            error_log('Failed to open sendmail [' . $this->sendmail_path . '] for execution.');
        	return false;
        }

        fputs($mail, $text_headers . $this->sep . $this->sep);

        fputs($mail, $body);
        $result = pclose($mail);
        if ($result != 0)
            return false;
        
        return true;
    }

}
