'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* eslint-disable multiline-ternary, no-void */


var _babelCore = require('babel-core');

var _babelPresetMinify = require('babel-preset-minify');

var _babelPresetMinify2 = _interopRequireDefault(_babelPresetMinify);

var _webpackSources = require('webpack-sources');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function getDefault(actualValue, defaultValue) {
  return actualValue !== void 0 ? actualValue : defaultValue;
}

var BabelMinifyPlugin = function () {
  function BabelMinifyPlugin() {
    var minifyOpts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var pluginOpts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, BabelMinifyPlugin);

    this.options = {
      parserOpts: pluginOpts.parserOpts || {},
      minifyPreset: pluginOpts.minifyPreset || _babelPresetMinify2.default,
      minifyOpts,
      babel: pluginOpts.babel || { transform: _babelCore.transform },
      comments: getDefault(pluginOpts.comments, /^\**!|@preserve|@license|@cc_on/),
      // compiler.options.devtool overrides options.sourceMap if NOT set
      // so we set it to void 0 as the default value
      sourceMap: getDefault(pluginOpts.sourceMap, void 0),
      jsregex: pluginOpts.test || /\.js($|\?)/i
    };
  }

  _createClass(BabelMinifyPlugin, [{
    key: 'apply',
    value: function apply(compiler) {
      var options = this.options;
      // if sourcemap is not set

      options.sourceMap = getDefault(options.sourceMap, !!compiler.options.devtool);

      compiler.plugin('compilation', function (compilation) {
        if (options.sourceMap) {
          compilation.plugin('build-module', function (module) {
            module.useSourceMap = true;
          });
        }

        compilation.plugin('optimize-chunk-assets', function (chunks, callback) {
          var files = [];

          chunks.forEach(function (chunk) {
            chunk.files.forEach(function (file) {
              return files.push(file);
            });
          });

          compilation.additionalChunkAssets.forEach(function (file) {
            return files.push(file);
          });

          files.filter(function (file) {
            return options.jsregex.test(file);
          }).forEach(function (file) {
            try {
              var asset = compilation.assets[file];

              if (asset.__babelminified) {
                compilation.assets[file] = asset.__babelminified;
                return;
              }

              var input = void 0;
              var inputSourceMap = void 0;

              if (options.sourceMap) {
                if (asset.sourceAndMap) {
                  var sourceAndMap = asset.sourceAndMap();
                  inputSourceMap = sourceAndMap.map;
                  input = sourceAndMap.source;
                } else {
                  inputSourceMap = asset.map();
                  input = asset.source();
                }
              } else {
                input = asset.source();
              }

              // do the transformation
              var result = options.babel.transform(input, {
                parserOpts: options.parserOpts,
                presets: [[options.minifyPreset, options.minifyOpts]],
                sourceMaps: options.sourceMap,
                babelrc: false,
                inputSourceMap,
                shouldPrintComment(contents) {
                  return shouldPrintComment(contents, options.comments);
                }
              });

              asset.__babelminified = compilation.assets[file] = result.map ? new _webpackSources.SourceMapSource(result.code, file, result.map, input, inputSourceMap) : new _webpackSources.RawSource(result.code);
            } catch (e) {
              compilation.errors.push(e);
            }
          });

          callback();
        });
      });
    }
  }]);

  return BabelMinifyPlugin;
}();

exports.default = BabelMinifyPlugin;


function shouldPrintComment(contents, checker) {
  switch (typeof checker) {
    case 'function':
      return checker(contents);
    case 'object':
      return checker.test(contents);
    default:
      return !!checker;
  }
}