<?php
define('SITE_DIR', realpath(str_replace(basename(__FILE__), "", __FILE__) . "../") . '/');
$running = null;
//sleep(10);
exec("pgrep -fl import.php", $running);
if(count($running) > 3){
	file_put_contents(SITE_DIR . 'import.log', json_encode($running));
	echo "script is in progress \n";
	exit();
}


require_once SITE_DIR.'atm/Loader.php';
Loader::addToPath(array(SITE_DIR.'atm', SITE_DIR.'/lib', SITE_DIR.'/lib/dao', SITE_DIR.'/atm/dao'));

$admin_zone = false;
require_once SITE_DIR.'confs/conf.php';
require_once SITE_DIR.'confs/db.php';
mb_internal_encoding('UTF-8');

$db = new Db_Mysql_Adapter();
Db_Dao::$db = $db;

$importDao = new Import_Dao();
$libraryImport = new Import_Library();
$bookImport = new Import_Book();
$libraryDao = new Library_Dao();
$bookDao = new Book_Dao();
$userDao = new User_Dao();

$item = $importDao->one(Db_Criteria::create(array('processed' => 0)));
if($item == null){
	exit();
}
$f = fopen(SITE_DIR . $item->file, 'r');
if(!$f){
	$importDao->update($item->id, array('processed' => 1, 'error' => 'не удалось открыть файл'));
	exit();
}
$n = 0;
$pass = 0;
$import = null;
$fundType = $item->fund;

$rowLength = 0;
$correctLine = '';

while($line = fgets($f)){

    if(strlen($correctLine) > 0) {
        $line = $correctLine . $line;
    }

    if($n == 0){
        if(strpos(mb_strtolower($line), "isbn") === false && strpos(mb_strtolower($line), "адрес") !== false){
            $import = $libraryImport;
            $pass = 2; // default 2 if XLS has title row
        }else{
            $import = $bookImport;
            $pass = 2; // default 2
        }
    }
    $n++;
    if($n < $pass){
        continue;
    }
    $parts = str_getcsv($line, ";");

    if($rowLength > 0 && count($parts) < $rowLength) {
        $correctLine = $line;
        continue;
    } else {
        $correctLine = '';
    }
    $rowLength = count($parts);

    $result = $import->import($parts, $fundType);
    if($result !== true){
        $importDao->update($item->id, array('processed' => 1, 'error' => $result));
        fclose($f);
        exit();
    }
}

$libraries = $libraryDao->all();
foreach($libraries as $l){
	$books = $bookDao->count(Db_Criteria::create(array('library_id' => $l->id)));
	$libraryDao->update($l->id, array('published' => $books > 0 ? 1 : 0));
	$user = $userDao->one(Db_Criteria::create(array('library_id' => $l->id)));
	if($user != null){
		$userDao->update($user->id, array('isblocked' => $books > 0 ? 0 : 1));
	}
}

fclose($f);
$importDao->update($item->id, array('processed' => 1));
echo "Import done!\n";
?>
