const webpack = require('webpack')
const path = require('path')
const HTMLWebpackPlugin = require('html-webpack-plugin')
const MinifyPlugin = require('babel-minify-webpack-plugin')

module.exports = {
    entry: './assets/mobile/index',
    output: {
        path: path.resolve('./assets/mobile/dist'),
        chunkFilename: '[name].bundle.js',
        filename: '[name].bundle.js',
        publicPath: '/assets/mobile/dist/'
    },
    plugins: [
      new HTMLWebpackPlugin({
          title: 'Code Splitting'
      }),
        new MinifyPlugin()
    ],
    module: {
        rules: [
            {
                test: /\.js?$/,
                exclude: /node_modules/,
                use: {
                    loader: 'babel-loader',
                    options: {
                        presets: ['es2015'],
                        plugins: ['syntax-dynamic-import']
                    }
                }
            }
        ]
    }
}