package subcmd

import (
	"context"
	"flag"
	"log"

	"code.justin.tv/beefcake/server/internal/client"
	"code.justin.tv/beefcake/server/internal/config"
	"github.com/aws/aws-sdk-go/service/ecs"
	"github.com/aws/aws-sdk-go/service/ecs/ecsiface"
)

// Base for all commands
type Base struct {
	Logger  *log.Logger
	env     string
	buildID string

	config *config.Config
	ecs    ecsiface.ECSAPI
}

// SetFlags implements subcommands
func (cmd *Base) SetFlags(f *flag.FlagSet) {
	f.StringVar(&cmd.buildID, "build-id", "", "Git commit to use to create the task definition.")
	f.StringVar(&cmd.env, "env", "", "Environment to create a task definition in.")
}

func (cmd *Base) init(ctx context.Context) (err error) {
	clientLoader, err := client.EnvironmentLoader(cmd.env)
	if err != nil {
		return err
	}

	clientLoader = clientLoader.
		WithCustomSessionRole(clientLoader.Config().ECSDeployRoleArn.Get())

	cmd.config = clientLoader.Config()
	cmd.ecs = ecs.New(clientLoader.Session())
	return nil
}
