// +build e2e

package e2e

import (
	"flag"
	"log"
	"os"
	"testing"
)

var et e2eTest

func TestMain(m *testing.M) {
	flag.StringVar(
		&et.environment,
		"e2e.environment",
		"testing",
		"Environment to test.",
	)

	flag.Parse()

	if err := et.Setup(); err != nil {
		log.Fatal(err)
	}
	defer et.CleanUp()

	os.Exit(m.Run())
}
