package main

import (
	"log"
	"os"

	"code.justin.tv/beefcake/server/internal/client"
	"github.com/aws/aws-lambda-go/lambda"
)

func main() {
	env, ok := os.LookupEnv("BEEFCAKE_ENVIRONMENT")
	if !ok {
		log.Fatal("BEEFCAKE_ENVIRONMENT is required")
	}

	clientLoader, err := client.EnvironmentLoader(env)
	if err != nil {
		log.Fatal(err.Error())
	}

	h := &handler{
		Config:            clientLoader.Config(),
		LegacyPermissions: clientLoader.LegacyPermissions(),
	}
	lambda.Start(h.Handle)
}
