package statsrunner

import (
	"hash/adler32"

	"code.justin.tv/sse/malachai/pkg/internal/stats"
)

// IncrementableMetric implements a hash function for IncrementableMetric.
type IncrementableMetric struct {
	*stats.IncrementableMetric
}

// ToKey returns a hash key for the metric
func (im *IncrementableMetric) toKey() (key string, err error) {
	h := adler32.New()
	_, err = h.Write([]byte(im.MetricName))
	if err != nil {
		return
	}

	for _, dimension := range im.Dimensions {
		_, err = h.Write([]byte(dimension.Name))
		if err != nil {
			return
		}

		_, err = h.Write([]byte(dimension.Value))
		if err != nil {
			return
		}
	}

	key = string(h.Sum(nil))
	return
}
