resource "aws_iam_role" "config-read" {
  name               = "${local.prefix}-config-read"
  assume_role_policy = "${data.aws_iam_policy_document.config-read-arp.json}"
}

data "aws_iam_policy_document" "config-read-arp" {
  statement {
    actions = ["sts:AssumeRole"]
    effect  = "Allow"

    principals {
      type = "AWS"

      identifiers = [
        "${local.aws_root_arn}",
        "${var.allowed_deployment_arns}",
        "${var.allowed_service_arns}",
        "${aws_iam_role.service.arn}",
        "${aws_iam_role.sync-roles-to-users.arn}",
      ]
    }
  }
}

resource "aws_iam_role_policy" "config-read" {
  role   = "${aws_iam_role.config-read.id}"
  policy = "${data.aws_iam_policy_document.config-read-rp.json}"
}

data "aws_iam_policy_document" "config-read-rp" {
  statement {
    actions = ["s3:GetObject"]

    resources = [
      "${aws_s3_bucket.config.arn}/config.json",
    ]
  }
}
