resource "aws_s3_bucket" "config" {
  bucket = "${local.config_bucket}"
}

resource "aws_s3_bucket_object" "config" {
  bucket = "${aws_s3_bucket.config.bucket}"
  key    = "config.json"
  acl    = "bucket-owner-full-control"

  content = "${jsonencode(merge(
    map(
      "AWSRegion", "us-west-2",
      "Environment", "${var.env}",
      "S2SServiceName", "beefcake-${var.env}",

      "ECSClusterName", "${data.aws_ecs_cluster.main.cluster_name}",
      "ECSDeployRoleArn", "${aws_iam_role.ecs-deploy.arn}",
      "ECSServiceName", "${local.ecs_service_name}",

      "IntegrationS2SServiceName", "beefcake-${var.env}-integration",

      "LegacyPermissionsHashKey", "${aws_dynamodb_table.legacy-permissions.hash_key}",
      "LegacyPermissionsTableName", "${aws_dynamodb_table.legacy-permissions.name}",

      "RolesHashKey", "${aws_dynamodb_table.roles.hash_key}",
      "RolesTableName", "${aws_dynamodb_table.roles.name}",

      "LambdasS3Bucket", "${aws_s3_bucket.lambdas.bucket}",
      "SyncRolesToUsersLambdaKey", "${local.sync_roles_to_users_lambda_key}",
      "SyncRolesToLegacyPermissionsLambdaKey", "${local.sync_roles_to_legacy_permissions_lambda_key}",
      "SyncLegacyPermissionsToRolesLambdaKey", "${local.sync_legacy_permissions_to_roles_lambda_key}",

      "TaskContainerPort", "${local.load_balancer_container_port}",
      "TaskExecutionRoleArn", "${aws_iam_role.ecs-execution.arn}",
      "TaskFamily", "${local.ecs_task_family}",
      "TaskLogGroup", "${aws_cloudwatch_log_group.ecs-service.name}",
      "TaskLogStreamPrefix", "${local.prefix}",
      "TaskServiceRoleArn", "${aws_iam_role.service.arn}",

      "UsersHashKey", "${aws_dynamodb_table.users.hash_key}",
      "UsersTableName", "${aws_dynamodb_table.users.name}",
    ),
  ))}"
}
