resource "aws_iam_role" "ecs-execution" {
  name               = "${local.prefix}-ecs-execution"
  assume_role_policy = "${data.aws_iam_policy_document.ecs-execution.json}"
}

data "aws_iam_policy_document" "ecs-execution" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    principals {
      type        = "Service"
      identifiers = ["ecs-tasks.amazonaws.com", "ecs.amazonaws.com"]
    }
  }
}

resource "aws_iam_role_policy_attachment" "ecs-execution" {
  role       = "${aws_iam_role.ecs-execution.name}"
  policy_arn = "arn:aws:iam::aws:policy/service-role/AmazonECSTaskExecutionRolePolicy"
}
