// Creates the ECS infrastructure to serve application in.

variable "acm_certificate_arn" {
  description = "ACM certificate to service ALB with."
}

variable "allowed_deployment_arns" {
  description = "ARNs allowed to assume deployment roles."
  type        = "list"
}

variable "allowed_service_arns" {
  type        = "list"
  description = "List of IAM arns allowed to assume this role."
}

variable "ecs_cluster_name" {
  description = "ECS cluster name to insert service into. This is generally the account name"
}

variable "env" {
  description = "Environment identifier. This will also prefix all resources."
}

variable "security_groups" {
  description = "Security groups to put service in."
  type        = "list"
}

variable "subnet_ids" {
  description = "Subnets to put service in."
  type        = "list"
}

variable "vpc_id" {
  description = "VPC to run service in."
}

data "aws_caller_identity" "current" {}

locals {
  // bucket that the stack resources are written to
  config_bucket = "beefcake-v3-${var.env}"

  // prefix for all resources
  prefix = "beefcake-v3-${var.env}"

  // vanity service name for AWS Tags
  service_name = "beefcake"

  // name of container in task definition to register with the load balancer
  load_balancer_container_name = "app"

  // port of container in task definition to register with the load balancer
  load_balancer_container_port = "8080"

  ecs_service_name = "${local.prefix}"
  ecs_task_family  = "${local.prefix}"

  sync_roles_to_users_lambda_key              = "sync-roles-to-users.zip"
  sync_roles_to_legacy_permissions_lambda_key = "sync-roles-to-legacy-permissions.zip"
  sync_legacy_permissions_to_roles_lambda_key = "sync-legacy-permissions-to-roles.zip"

  aws_account_id = "${data.aws_caller_identity.current.account_id}"
  aws_root_arn   = "arn:aws:iam::${local.aws_account_id}:root"
}

output "aws_alb_listener_arn" {
  value = "${aws_alb_listener.ecs-service.arn}"
}
