resource "aws_dynamodb_table" "roles" {
  name             = "${local.prefix}-roles"
  read_capacity    = 10
  write_capacity   = 10
  hash_key         = "ID"
  stream_enabled   = true
  stream_view_type = "NEW_AND_OLD_IMAGES"

  attribute {
    name = "ID"
    type = "S"
  }

  tags {
    Project = "${local.prefix}"
  }

  lifecycle {
    ignore_changes = [
      "read_capacity",
      "write_capacity",
    ]
  }
}

resource "aws_lambda_event_source_mapping" "sync-roles-to-users" {
  batch_size        = 100
  event_source_arn  = "${aws_dynamodb_table.roles.stream_arn}"
  enabled           = true
  function_name     = "${aws_lambda_function.sync-roles-to-users.arn}"
  starting_position = "LATEST"
}

resource "aws_lambda_event_source_mapping" "sync-roles-to-legacy-permissions" {
  batch_size        = 100
  event_source_arn  = "${aws_dynamodb_table.roles.stream_arn}"
  enabled           = true
  function_name     = "${aws_lambda_function.sync-roles-to-legacy-permissions.arn}"
  starting_position = "LATEST"
}
