resource "aws_iam_role" "service" {
  name               = "${local.prefix}-service"
  assume_role_policy = "${data.aws_iam_policy_document.service-arp.json}"
}

data "aws_iam_policy_document" "service-arp" {
  statement {
    actions = ["sts:AssumeRole"]
    effect  = "Allow"

    principals = {
      type        = "Service"
      identifiers = ["ecs.amazonaws.com", "ecs-tasks.amazonaws.com"]
    }

    principals {
      type        = "AWS"
      identifiers = ["${var.allowed_service_arns}"]
    }
  }
}

resource "aws_iam_role_policy" "service" {
  role   = "${aws_iam_role.service.id}"
  policy = "${data.aws_iam_policy_document.service-rp.json}"
}

data "aws_iam_policy_document" "service-rp" {
  statement {
    actions = ["sts:AssumeRole"]

    resources = [
      "${aws_iam_role.config-read.arn}",
      "arn:aws:iam::180116294062:role/malachai/*",
    ]
  }

  statement {
    actions = [
      "dynamodb:DeleteItem",
      "dynamodb:GetItem",
      "dynamodb:PutItem",
      "dynamodb:UpdateItem",
      "dynamodb:Scan",
    ]

    resources = [
      "${aws_dynamodb_table.roles.arn}",
    ]
  }

  statement {
    actions = [
      "dynamodb:ConditionCheckItem",
      "dynamodb:DeleteItem",
      "dynamodb:GetItem",
      "dynamodb:PutItem",
      "dynamodb:UpdateItem",
      "dynamodb:Scan",
    ]

    resources = [
      "${aws_dynamodb_table.legacy-permissions.arn}",
    ]
  }

  statement {
    actions = [
      "dynamodb:GetItem",
    ]

    resources = [
      "${aws_dynamodb_table.users.arn}",
    ]
  }

  statement {
    actions   = ["dynamodb:UpdateItem"]
    resources = ["${aws_dynamodb_table.users.arn}"]

    condition {
      test     = "ForAllValues:StringEquals"
      variable = "dynamodb:Attributes"
      values   = ["ID", "LastAccessTime"]
    }
  }
}
