data "aws_s3_bucket_object" "sync-roles-to-users" {
  bucket = "${aws_s3_bucket.lambdas.bucket}"
  key    = "${local.sync_roles_to_users_lambda_key}"
}

resource "aws_lambda_function" "sync-roles-to-users" {
  function_name     = "${local.prefix}-sync-roles-to-users"
  handler           = "main"
  role              = "${aws_iam_role.sync-roles-to-users.arn}"
  runtime           = "go1.x"
  s3_bucket         = "${data.aws_s3_bucket_object.sync-roles-to-users.bucket}"
  s3_key            = "${data.aws_s3_bucket_object.sync-roles-to-users.key}"
  s3_object_version = "${data.aws_s3_bucket_object.sync-roles-to-users.version_id}"
  timeout           = "900"

  environment {
    variables {
      BEEFCAKE_ENVIRONMENT = "${var.env}"
    }
  }

  tags {
    Project = "${local.prefix}"
  }
}

resource "aws_iam_role" "sync-roles-to-users" {
  name               = "${local.prefix}-sync-roles-to-users"
  assume_role_policy = "${data.aws_iam_policy_document.lambda-arp.json}"

  tags {
    Project = "${local.prefix}"
  }
}

resource "aws_iam_role_policy" "sync-roles-to-users" {
  role   = "${aws_iam_role.sync-roles-to-users.name}"
  policy = "${data.aws_iam_policy_document.sync-roles-to-users-rp.json}"
}

data "aws_iam_policy_document" "sync-roles-to-users-rp" {
  statement {
    actions   = ["sts:AssumeRole"]
    resources = ["${aws_iam_role.config-read.arn}"]
  }

  statement {
    actions = [
      "logs:PutLogEvents",
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents",
    ]

    resources = ["*"]
  }

  statement {
    actions = [
      "dynamodb:UpdateItem",
    ]

    resources = ["${aws_dynamodb_table.users.arn}"]
  }

  statement {
    actions = [
      "dynamodb:GetRecords",
      "dynamodb:GetShardIterator",
      "dynamodb:DescribeStream",
      "dynamodb:ListStreams",
    ]

    resources = ["${aws_dynamodb_table.roles.stream_arn}"]
  }
}
