provider "aws" {
  region  = "us-west-2"
  profile = "twitch-beefcake-aws"
}

terraform {
  backend "s3" {
    bucket  = "twitch-beefcake-aws"
    key     = "tfstate/beefcake/beefcake-server/production"
    profile = "twitch-beefcake-aws"
    region  = "us-west-2"
  }
}

module "beefcake" {
  source = "../modules/beefcake"

  acm_certificate_arn = "arn:aws:acm:us-west-2:193346998399:certificate/073b6c18-2a9f-4499-a13d-febc60ea759a"
  ecs_cluster_name    = "twitch-beefcake-aws"
  env                 = "production"
  vpc_id              = "vpc-038403550d412c391"

  allowed_deployment_arns = [
    "arn:aws:iam::516651178292:user/jenkins",
  ]

  allowed_service_arns = []

  security_groups = [
    "sg-0d6eaa7ef0f5e2345",
  ]

  subnet_ids = [
    "subnet-03137ad8626fa933d",
    "subnet-0f2a151a2deede6fb",
    "subnet-064f0e3e1c2d80e75",
  ]
}

output "aws_alb_listener_arn" {
  value = "${module.beefcake.aws_alb_listener_arn}"
}
