provider "aws" {
  region  = "us-west-2"
  profile = "twitch-beefcake-dev"
}

terraform {
  backend "s3" {
    bucket  = "twitch-beefcake-dev"
    key     = "tfstate/beefcake/beefcake-server/staging"
    profile = "twitch-beefcake-dev"
    region  = "us-west-2"
  }
}

module "beefcake" {
  source = "../modules/beefcake"

  acm_certificate_arn = "arn:aws:acm:us-west-2:333838943856:certificate/ae2fe8c2-864b-492c-9e63-6d4f87a1c954"
  ecs_cluster_name    = "twitch-beefcake-dev"
  env                 = "staging"
  vpc_id              = "vpc-0cc2be10014f72821"

  allowed_deployment_arns = [
    "arn:aws:iam::516651178292:user/jenkins",
  ]

  allowed_service_arns = []

  security_groups = [
    "sg-0b20fbd8d3a87d704",
  ]

  subnet_ids = [
    "subnet-06485ebab3dc6c85a",
    "subnet-0bbf9a3ef0c8bad4b",
    "subnet-0de7b46f6530debb7",
  ]
}

output "aws_alb_listener_arn" {
  value = "${module.beefcake.aws_alb_listener_arn}"
}
