provider "aws" {
  region  = "us-west-2"
  profile = "twitch-beefcake-dev"
}

terraform {
  backend "s3" {
    bucket  = "twitch-beefcake-dev"
    key     = "tfstate/beefcake/beefcake-server/testing"
    profile = "twitch-beefcake-dev"
    region  = "us-west-2"
  }
}

module "beefcake" {
  source = "../modules/beefcake"

  acm_certificate_arn = "arn:aws:acm:us-west-2:333838943856:certificate/5b1819c3-a63a-43ab-a3ad-3ef3934c3f46"
  ecs_cluster_name    = "twitch-beefcake-dev"
  env                 = "testing"
  vpc_id              = "vpc-0cc2be10014f72821"

  allowed_deployment_arns = ["arn:aws:iam::516651178292:user/jenkins"]

  allowed_service_arns = [
    // jenkins user
    "arn:aws:iam::516651178292:user/jenkins",

    // for running e2e tests locally
    "arn:aws:iam::333838943856:root",
  ]

  security_groups = [
    "sg-0b20fbd8d3a87d704",
  ]

  subnet_ids = [
    "subnet-06485ebab3dc6c85a",
    "subnet-0bbf9a3ef0c8bad4b",
    "subnet-0de7b46f6530debb7",
  ]
}

output "aws_alb_listener_arn" {
  value = "${module.beefcake.aws_alb_listener_arn}"
}
