package logger

import (
	"fmt"
	"os"
	"os/exec"
	"time"
)

const (
	defaultFileLoggerTick     = time.Second * 1
	defaultFileSize       int = 100000000
)

var (
	fileLog         bool
	fileLogBuff     chan string
	fileLoggerDead  bool
	killFileLogger  chan bool
	rotatedFileName = "%s:%s"
)

func KillFileLogger() {
	killFileLogger <- true
	for fileLoggerDead == false {

	}
}

type fileLogger struct {
	fileName string
	file     *os.File
	size     int
	actual   int
	ticker   *time.Ticker
}

func (f *fileLogger) run() {
	defer f.rotate()
	defer f.ticker.Stop()
	loop := true
	for loop == true {
		select {
		case <-killFileLogger:
			loop = false
			f.file.Sync()
			fileLoggerDead = true
		case <-f.ticker.C:
			f.file.Sync()
		case str := <-fileLogBuff:
			if f.actual+len(str) > f.size {
				f.rotate()
				f.actual = 0
			}
			f.file.WriteString(fmt.Sprintf("%s %s\n", time.Now().String(), str))
			f.actual = f.actual + len(str)
		}
	}
}

func (f *fileLogger) rotate() {
	f.file.Sync()
	f.file.Close()
	cmd := exec.Command(
		"mv",
		f.fileName,
		fmt.Sprintf("%s.%d", f.fileName, time.Now().UnixNano()),
	)
	err := cmd.Run()
	if err != nil {
		return
	}
	f.file, err = os.Create(f.fileName)
	if err != nil {
		return
	}
}

// FileLogger will set up file logging for your applicaton.
// Call with size and the name of the file.
//
// NOTE: size is in bytes
//
func FileLogger(size int, name string) error {
	killFileLogger = make(chan bool, 1)
	if size == 0 {
		size = defaultFileSize
	}
	file, err := os.Create(name)
	if err != nil {
		return err
	}
	fileLog = true
	fileLogBuff = make(chan string, 5000)
	f := &fileLogger{
		fileName: name,
		file:     file,
		size:     size,
		ticker:   time.NewTicker(defaultFileLoggerTick),
	}
	go f.run()
	return nil
}
