package statsd

import (
	"net"
	"time"

	"code.justin.tv/video/streamlog/pkg/logger"
	"github.com/cactus/go-statsd-client/statsd"
)

var (
	AppName string
	Conn    statsd.Statter
	Enabled bool
	Host    string
	Port    string
)

func Init() {
	if Enabled {
		Conn = mustDial()
	}
}

func mustDial() statsd.Statter {
	s, err := statsd.Dial(net.JoinHostPort(Host, Port), AppName)
	if err != nil {
		logger.Error(
			"statsd.mustDial",
			"got err: %v",
			err,
		)
		for i := 0; i < 5; i++ {
			time.Sleep(200 * time.Millisecond)
			s, err := statsd.Dial(net.JoinHostPort(Host, Port), AppName)
			if err == nil {
				return s
			}
		}
		panic("statsd.mustdial: could not get connection")
	}
	return s
}

func Inc(stat string, value int64, rate float32) error {
	if Enabled {
		return Conn.Inc(stat, value, rate)
	}
	return nil
}

func Gauge(stat string, value int64, rate float32) error {
	if Enabled {
		return Conn.Gauge(stat, value, rate)
	}
	return nil
}

func GaugeDelta(stat string, value int64, rate float32) error {
	if Enabled {
		return Conn.GaugeDelta(stat, value, rate)
	}
	return nil
}

func Timing(stat string, value time.Duration, rate float32) error {
	if Enabled {
		return Conn.Timing(stat, int64(value/time.Millisecond), rate)
	}
	return nil
}

func Raw(stat string, value string, rate float32) error {
	if Enabled {
		return Conn.Raw(stat, value, rate)
	}
	return nil
}
