package main

import (
	"flag"
	"fmt"
	"log"
	"net/http"
	"os"

	"code.justin.tv/video/streamlog/pkg/statsd"

	"code.justin.tv/abuse/shodan/api"
	"code.justin.tv/abuse/shodan/config"
	"code.justin.tv/abuse/shodan/iprep"
	"code.justin.tv/abuse/shodan/whitelist"
)

const (
	iprepAPIEndpoint = "/v1/iprep/"
)

func healthCheck(w http.ResponseWriter, r *http.Request) {
	fmt.Fprintf(w, "Looking good.\n")
}

func main() {
	// end up in /var/log/web-1.log, not /var/log/web-1.error.log
	log.SetOutput(os.Stdout)

	log.Println("shodan starting up.")

	flag.Parse()

	statsd.Enabled = true
	statsd.AppName = *config.StatsdAppName
	statsd.Host = *config.StatsdHost
	statsd.Port = *config.StatsdPort
	statsd.Init()
	statsd.Inc("server.start", 1, 1)

	whitelist := whitelist.New(*config.OverusedIPsHostName, *config.OverusedIPsPort)
	go whitelist.Run()
	repSource, err := iprep.NewSource(*config.AsnPath, *config.RepDBPath, whitelist, nil)
	if err != nil {
		log.Fatal("couldn't start iprep source:", err)
	}
	handler := api.NewHandler(iprepAPIEndpoint, repSource)
	http.Handle(iprepAPIEndpoint, handler)
	http.HandleFunc("/health", healthCheck)
	log.Fatal(http.ListenAndServe(*config.ListenAddress, nil))
}
