def project = 'viewcounts-ace-alerts'
def team = 'benherr'
def name = "${team}-${project}"
def repo = "${team}/${project}"

job name, {
  using 'TEMPLATE-autobuild'

  triggers {
    githubPush {
      githubPolling(false)
    }
  }

  wrappers {
    credentialsBinding {
      string 'AWS_ACCESS_KEY', 'video-aws-access-key'
      string 'AWS_SECRET_KEY', 'video-aws-secret-key'
    }
  }

  scm {
    git {
      remote {
        github repo, 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
      githubPolling(false)
    }
  }

  steps {
    shell "make build"
  }
}

job "${name}-deploy", {
  using "TEMPLATE-deploy"

  scm {
    git {
      remote {
        github repo, 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
      githubPolling(false)
    }
  }

  steps {
    shell "make deploy"
  }
}
