with gvc_adjust as (
  select
    cc.time + interval '{{timezone_correction}}' as time,
    cc.channel,
    cc.host,
    cc.env,
    cc.merged
  from logs.pn_channel_concurrents cc
),
gvc as (
  select
    date_trunc('hour', cc.time) + (extract(minute from cc.time) / ({{agg_interval}}))::integer * ({{agg_interval}}) * interval '1 minute' as timep,
    cc.channel,
    cc.host,
    {{agg_fn}}(cc.merged) as count,
		stddev_samp(cc.merged) as stddev
  from gvc_adjust cc
  where cc.time >= date_trunc('hour', datetime 'now') - interval '{{time_from}}'
    and cc.time < date_trunc('hour', datetime 'now') - interval '{{time_to}}'
    and cc.env = 'production'
  {% if single_channel != "" %}
    and cc.channel = '{{single_channel}}'
  {% endif %}
  group by 1, 2, 3
),
cc_adjust as (
  select
    cc.time + interval '{{timezone_correction}}' - interval '{{gvc_cc_time_offset}}' as time,
    cc.channel,
    cc.total
  from logs.channel_concurrents cc
),
cc as (
  select
    date_trunc('hour', cc.time) + (extract(minute from cc.time) / ({{agg_interval}}))::integer * ({{agg_interval}}) * interval '1 minute' as timep,
    cc.channel,
    {{agg_fn}}(total) as count,
		stddev_samp(total) as stddev
  from cc_adjust cc
  where cc.time >= date_trunc('hour', datetime 'now') - interval '{{time_from}}'
    and cc.time < date_trunc('hour', datetime 'now') - interval '{{time_to}}'
  {% if single_channel != "" %}
    and cc.channel = '{{single_channel}}'
  {% endif %}
  group by 1, 2
),
diff as (
  select
    gvc.timep as time_gvc,
    cc.timep as time_cc,
    cc.channel,
    gvc.host,
    gvc.count as gvc,
    cc.count as cc,
    cc.count::real / case gvc.count
      when 0 then 1
      else gvc.count
    end - 1 as diff,
    gvc.count - cc.count as abs_diff,
		case when gvc.stddev+cc.stddev > abs(gvc.count - cc.count) then 0 else 1 end as big_diff_event
  from cc
  join gvc on gvc.timep = cc.timep
          and gvc.channel = cc.channel
)

select
  diff.host,
  Sum(Abs(diff.abs_diff)) as abs_diff,
  (Sum(Abs(diff.abs_diff)) * 100.0 / Sum(diff.gvc))::real as rel_diff,
  (Sum(Abs(diff.diff)) * 100.0 / Count(diff.diff))::real as avg_diff,
  (Avg(diff.big_diff_event::float)) as big_diff_event_prob
from diff
where diff.gvc > {{min_gvc}}
  and diff.cc > {{min_cc}}
group by diff.host

{% form %}

timezone_correction:
  type: text
  default: '7 hours'

time_from:
  type: text
  default: '36 hours'

time_to:
  type: text
  default: '90 minutes'

agg_fn:
  type: text
  default: 'Avg'

agg_interval:
  type: text
  default: '15'

min_cc:
  type: text
  default: '20'

min_gvc:
  type: text
  default: '20'

gvc_cc_time_offset:
  type: text
  default: '30 seconds'

single_channel:
  type: text
  default: ''

{% endform %}
