require 'aws-sdk'
require 'pg'

def redshift_connect(cluster_identifier:, user:, region: "us-west-2", db: "production", use_internal_ip: true)
  redshift = Aws::Redshift::Client.new(region: region)

  resp = redshift.describe_clusters(
    cluster_identifier: cluster_identifier,
  )

  host, port, sslmode = if use_internal_ip
    nodes = resp.clusters.first.cluster_nodes
    leader = nodes.select{|node| node.node_role == "LEADER"}.first
    [leader.private_ip_address, 5439, "verify-ca"]
  else
    endpoint = resp.clusters.first.endpoint
    [endpoint.address, endpoint.port, "verify-full"]
  end

  creds = redshift.get_cluster_credentials(
    db_user: user,
    cluster_identifier: cluster_identifier,
  )

  conn = PG.connect(
    dbname: db,
    host: host,
    port: port,
    user: creds.db_user,
    password: creds.db_password,
    sslmode: sslmode,
  )
  conn.type_map_for_results = PG::BasicTypeMapForResults.new(conn)

  return conn
end

def redshift_query(conn, query, log: STDOUT, timeout: 3*60*60, retries: 3)
  result = nil

  begin
    Timeout.timeout(timeout) do
      result = conn.async_exec(query)
      result.check
    end
  rescue => e
    log.puts "  #{e}, retries remaining: #{retries}"
    if retries > 0
      retries -= 1
      retry
    else
      raise
    end
  end
  # unsure about all these
  #rescue Timeout::Error
  #  retries -= 1
  #  if retries >= 0
  #    log.puts "  timed out; retrying"
  #    retry
  #  else
  #    log.puts "  giving up"
  #    raise
  #  end
  #rescue PG::QueryCanceled => e
  #  p e
  #  retry
  #rescue PG::InternalError => e
  #  p e
  #  msg = e.to_s

  #  case msg
  #  when /dropped by concurrent transaction/
  #    retry
  #  else
  #    raise
  #  end
  #rescue PG::UnableToSend
  #  retries -= 1
  #  if retries >= 0
  #    log.puts "  timed out; retrying"
  #    retry
  #  else
  #    log.puts "  giving up"
  #    raise
  #  end
  #end

  return result
end
