variable "project" {}
variable "team" {}
variable "repo" {}
variable "name" {}

output "repo" {
  value = "${aws_ecr_repository.repo.repository_url}"
}

provider "aws" {
  region = "us-west-2"
}

terraform {
  backend "s3" {
    region = "us-west-2"

    dynamodb_table = "terraform_locks"
    bucket         = "twitch-video-viewcounts-tfstate"
    key            = "dev/benherr-viewcounts-ace-alerts"
  }
}

resource "aws_ecr_repository" "repo" {
  name = "${var.name}"
}

resource "aws_ecs_task_definition" "task" {
  family                = "${var.name}"
  container_definitions = "${file("container.json")}"
  task_role_arn         = "${aws_iam_role.container.arn}"
}

resource "aws_iam_role" "container" {
  name               = "${var.name}-container"
  assume_role_policy = "${data.aws_iam_policy_document.ecs_assume.json}"
}

data "aws_iam_policy_document" "ecs_assume" {
  statement {
    actions = ["sts:AssumeRole"]

    principals {
      type        = "Service"
      identifiers = ["ecs-tasks.amazonaws.com"]
    }
  }
}

data "aws_iam_policy_document" "container" {
  statement {
    actions   = ["redshift:DescribeClusters"]
    resources = ["arn:aws:redshift:us-west-2:848744099708:cluster:viewbot-redshift2"]
  }

  statement {
    actions   = ["redshift:GetClusterCredentials"]
    resources = ["arn:aws:redshift:us-west-2:848744099708:dbuser:viewbot-redshift2/mode"]
  }
}

resource "aws_iam_role_policy" "container" {
  name   = "${var.name}-container"
  role   = "${aws_iam_role.container.name}"
  policy = "${data.aws_iam_policy_document.container.json}"
}
