
--NOTE: create a table for the "denominator" of the cme metric
--SPEC FOR ---> dx_sandbox.metric_cme_helper_denominator_total_hw
-- the_day
-- channel_id
-- the_game
-- platform
-- total_hw




-- --Create the Table with explicit schema types  NOTE: IF NOT EXISTS IS AN OPTIONAL KEYWORD
-- CREATE TABLE IF NOT EXISTS dx_sandbox.metric_cme_helper_denominator_total_hw (
--     the_day                     DATE sortkey
--     , channel_id                BIGINT
--     , the_game                  VARCHAR(500) distkey
--     , platform                  VARCHAR(50)
--     , total_hw                  FLOAT
-- );



-- CHANGE the_index_date IF YOU WANT TO CHANGE THE RELATIVE DATE
CREATE TEMP TABLE the_dates_table AS (
  SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::DATE AS the_index_date --today's start date
);

--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function_metric_cme_helper_denominator_total_hw (BIGINT) AS
DELETE FROM dx_sandbox.metric_cme_helper_denominator_total_hw
WHERE the_day = DATEADD(  day, $1, (SELECT the_index_date FROM the_dates_table)  )
;


--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_sandbox.metric_cme_helper_denominator_total_hw);

--THEN WRITE YOUR SQL CODE FOR THE INSERT FUNCTION
PREPARE the_insert_function_metric_cme_helper_denominator_total_hw (BIGINT) AS
INSERT INTO the_temp_table (



  WITH
  the_parameter_input AS (
    SELECT DATEADD(  day, $1, (SELECT the_index_date FROM the_dates_table)  ) AS the_day_to_refresh_data_for
  )
  , the_constants_time AS (
    SELECT start_date, DATEADD(day, 1, start_date) AS end_date
    FROM (SELECT the_day_to_refresh_data_for AS start_date FROM the_parameter_input)
  )
  , daily_hours_watched_per_channel_platform_game AS (
    SELECT day AS the_day, channel_id, platform
      , f_game_flattened(game) AS game_flattened  --anything that isn't alphanumeric replace with blank
      , SUM(mw::FLOAT/60) AS hw
    FROM cubes.hours_watched_daily_by_device
    WHERE
      (SELECT start_date FROM the_constants_time)<=day AND day<(SELECT end_date FROM the_constants_time)
      AND content_mode IN ('live stream')
    GROUP BY 1,2,3,4
  )
  , final_data AS (
    SELECT the_day, channel_id, game_flattened, platform, hw
    FROM daily_hours_watched_per_channel_platform_game
  )
  SELECT * FROM final_data



);



--RUN INSERT AND DELETE

EXECUTE the_insert_function_metric_cme_helper_denominator_total_hw (-1); EXECUTE the_delete_function_metric_cme_helper_denominator_total_hw (-1);   INSERT INTO dx_sandbox.metric_cme_helper_denominator_total_hw    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_denominator_total_hw (-2); EXECUTE the_delete_function_metric_cme_helper_denominator_total_hw (-2);   INSERT INTO dx_sandbox.metric_cme_helper_denominator_total_hw    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_denominator_total_hw (-3); EXECUTE the_delete_function_metric_cme_helper_denominator_total_hw (-3);   INSERT INTO dx_sandbox.metric_cme_helper_denominator_total_hw    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_denominator_total_hw (-4); EXECUTE the_delete_function_metric_cme_helper_denominator_total_hw (-4);   INSERT INTO dx_sandbox.metric_cme_helper_denominator_total_hw    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
