CREATE TABLE IF NOT EXISTS dx_sandbox.daily_web_extension_viewer_funnel_helper_render (
  dt                                  TIMESTAMP WITHOUT TIME ZONE sortkey
  , channel_id                        BIGINT
  , extension_id                      VARCHAR(32)
  , extension_anchor                  VARCHAR(32)
  , device_id                         VARCHAR(32)
  , platform                          VARCHAR(40)
  , action                            VARCHAR(6)
);

CREATE TEMP TABLE temp_table (LIKE dx_sandbox.daily_web_extension_viewer_funnel_helper_render);

PREPARE the_delete_function_daily_web_extension_viewer_funnel_helper_render (BIGINT) AS
DELETE FROM dx_sandbox.daily_web_extension_viewer_funnel_helper_render
WHERE dt = DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')));

PREPARE the_insert_function_daily_web_extension_viewer_funnel_helper_render (BIGINT) AS
INSERT INTO temp_table (
  WITH the_parameter_constants AS (
    SELECT
      DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) as start_day,
      DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) + interval '1 day' as end_day
  )

  select
  date_trunc('day',time) as dt
  ,r.channel_id
  ,r.extension_id
  ,r.extension_anchor
  ,r.device_id
  ,r.platform
  ,'render' as action
  from tahoe.extension_render r
  -- JOIN the_parameter_constants b on r.time >= b.start_day and r.time < b.end_day
  -- render has to have existed on channel that day
  JOIN dx_sandbox.daily_web_extension_viewer_funnel_helper_channel_presence ced on r.time >= ced.the_day and r.time < ced.the_day + interval '1 day'
                                        and r.extension_id = ced.extension_id and r.channel_id = ced.channel_id
                                        and r.extension_anchor = ced.extension_anchor
  WHERE
  r.extension_anchor != 'NULL_EXTENSION_ANCHOR'
  and r.extension_anchor is not null
  and r.date >= (SELECT start_day FROM the_parameter_constants)
  and r.date < (SELECT end_day FROM the_parameter_constants)
  and r.extension_mode not in ('dashboard', 'config')
);

---
EXECUTE the_delete_function_daily_web_extension_viewer_funnel_helper_render(-4);
EXECUTE the_insert_function_daily_web_extension_viewer_funnel_helper_render(-4);
INSERT INTO dx_sandbox.daily_web_extension_viewer_funnel_helper_render
  (SELECT * FROM temp_table);
DELETE FROM temp_table;

EXECUTE the_delete_function_daily_web_extension_viewer_funnel_helper_render(-3);
EXECUTE the_insert_function_daily_web_extension_viewer_funnel_helper_render(-3);
INSERT INTO dx_sandbox.daily_web_extension_viewer_funnel_helper_render
  (SELECT * FROM temp_table);
DELETE FROM temp_table;

EXECUTE the_delete_function_daily_web_extension_viewer_funnel_helper_render(-2);
EXECUTE the_insert_function_daily_web_extension_viewer_funnel_helper_render(-2);
INSERT INTO dx_sandbox.daily_web_extension_viewer_funnel_helper_render
  (SELECT * FROM temp_table);
DELETE FROM temp_table;

EXECUTE the_delete_function_daily_web_extension_viewer_funnel_helper_render(-1);
EXECUTE the_insert_function_daily_web_extension_viewer_funnel_helper_render(-1);
INSERT INTO dx_sandbox.daily_web_extension_viewer_funnel_helper_render
  (SELECT * FROM temp_table);
DELETE FROM temp_table;

DEALLOCATE the_delete_function_daily_web_extension_viewer_funnel_helper_render;
DEALLOCATE the_insert_function_daily_web_extension_viewer_funnel_helper_render;
